/*
 * Decompiled with CFR 0.152.
 */
package com.chuweizi.hiktool.picker;

import com.alibaba.fastjson.JSONObject;
import com.chuweizi.hiktool.base.CategoryType;
import com.chuweizi.hiktool.base.HttpUtils;
import com.chuweizi.hiktool.base.PickerCache;
import com.chuweizi.hiktool.base.PickerConfig;
import com.chuweizi.hiktool.picker.EasyDarwinService;
import com.chuweizi.hiktool.picker.pojo.DeviceInfoVO;
import com.chuweizi.hiktool.picker.pojo.PerimeterVO;
import com.chuweizi.hiktool.picker.pojo.PersonCaptureVO;
import com.chuweizi.hiktool.picker.pojo.VehicleAccessVO;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="pickerService")
public class PickerService {
    private static final Logger log = LoggerFactory.getLogger(PickerService.class);
    @Autowired
    PickerConfig pickerConfig;
    @Autowired
    EasyDarwinService easyDarwinService;
    @Autowired
    HttpUtils httpUtils;
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public void deviceAdd(Map<String, List<DeviceInfoVO>> map) {
        map.forEach((category, list) -> list.forEach(device -> {
            device.setSerial(this.pickerConfig.getKey() + "-" + this.pickerConfig.getRegion() + "_" + category + device.getIp().split("\\.")[3]);
            if (device.getName() == null) {
                device.setName(device.getSerial());
            }
            device.setRegion(this.pickerConfig.getRegion());
            device.setCategory(category);
            device.setStatus(Integer.valueOf(1));
            if (StringUtils.hasText((String)device.getLnglat())) {
                device.setCenter(Arrays.stream(device.getLnglat().split(",")).map(Double::valueOf).collect(Collectors.toList()));
            }
            try {
                if (category.equals(CategoryType.camera.name())) {
                    this.easyDarwinService.streamStart(device);
                }
                log.info("\u7c7b\u578b" + category + "\u8bbe\u5907\u6ce8\u518c\u4e2d\uff1a" + device);
                HttpResponse response = this.httpUtils.httpSend(this.pickerConfig.getDeviceRegister(), "device", "device_add", device.getSerial(), this.df.format(new Date()), JSONObject.toJSONString((Object)device));
                log.info("\u7c7b\u578b" + category + "\u8bbe\u5907\u6ce8\u518c\u7ed3\u679c\uff1a" + EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
            if (category.equals(CategoryType.face.name())) {
                PickerCache.faceDeviceCache.put(device.getIp(), device);
            }
            if (category.equals(CategoryType.vehicle.name())) {
                PickerCache.vehicleDeviceCache.put(device.getIp(), device);
            }
            if (category.equals(CategoryType.camera.name())) {
                PickerCache.cameraDeviceCache.put(device.getIp(), device);
            }
            if (category.equals(CategoryType.perimeter.name())) {
                PickerCache.perimeterDeviceCache.put(device.getIp(), device);
            }
        }));
    }

    public void uploadPersonCapture(JSONObject dataJson, String fileBackground, String fileFace) {
        DeviceInfoVO deviceInfoVO = (DeviceInfoVO)PickerCache.faceDeviceCache.get(dataJson.getString("ip"));
        String timeCovert = this.df.format(dataJson.getDate("time"));
        String backgroundUrl = this.httpUtils.getPhotoUrl(fileBackground);
        PersonCaptureVO vo = new PersonCaptureVO();
        vo.setDeviceSerial(deviceInfoVO.getSerial());
        vo.setDeviceName(deviceInfoVO.getName());
        vo.setCapturedAt(timeCovert);
        vo.setImage(backgroundUrl);
        vo.setFace(fileFace == null ? backgroundUrl : this.httpUtils.getPhotoUrl(fileFace));
        vo.setDistrict(this.pickerConfig.getRegion());
        vo.setTargetIdType("11");
        vo.setSimilarity(Double.valueOf(0.0));
        if (dataJson.getInteger("sex") == 1 || dataJson.getInteger("sex") == 2) {
            vo.setTargetGender(dataJson.getInteger("sex"));
        }
        try {
            log.info("\u4eba\u8138\u6293\u62cd\u4e0a\u4f20\u5230\u8bbe\u5907\u7ba1\u7406\u5e73\u53f0\u7684\u6570\u636e\uff1a" + vo);
            HttpResponse response = this.httpUtils.httpSend(this.pickerConfig.getPersonCapture(), "data", "person_capture", vo.getDeviceSerial(), timeCovert, JSONObject.toJSONString((Object)vo));
            log.info("\u4eba\u8138\u6293\u62cd\u4e0a\u4f20\u7ed3\u679c\uff1a" + EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public void uploadVehicleAccess(JSONObject dataJson, String fileBackground) {
        DeviceInfoVO deviceInfoVO = (DeviceInfoVO)PickerCache.vehicleDeviceCache.get(dataJson.getString("ip"));
        String timeCovert = this.df.format(dataJson.getDate("time"));
        String backgroundUrl = this.httpUtils.getPhotoUrl(fileBackground);
        VehicleAccessVO vo = new VehicleAccessVO();
        vo.setDeviceSerial(deviceInfoVO.getSerial());
        vo.setDeviceName(deviceInfoVO.getName());
        vo.setDirection(Integer.valueOf(deviceInfoVO.getName().contains("\u5165\u53e3") ? 1 : 2));
        vo.setRecordAt(timeCovert);
        vo.setImage(backgroundUrl);
        vo.setDistrict(this.pickerConfig.getRegion());
        vo.setPlateNum(dataJson.getString("plateNo"));
        try {
            log.info("\u8f66\u8f86\u6293\u62cd\u4e0a\u4f20\u5230\u8bbe\u5907\u7ba1\u7406\u5e73\u53f0\u7684\u6570\u636e\uff1a" + vo);
            HttpResponse response = this.httpUtils.httpSend(this.pickerConfig.getVehicleAccess(), "data", "vehicle_access", vo.getDeviceSerial(), timeCovert, JSONObject.toJSONString((Object)vo));
            log.info("\u8f66\u8f86\u6293\u62cd\u4e0a\u4f20\u7ed3\u679c\uff1a" + EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public void uploadPerimeterAlarm(JSONObject dataJson) {
        DeviceInfoVO deviceInfoVO = (DeviceInfoVO)PickerCache.perimeterDeviceCache.get(dataJson.getString("ip"));
        String timeCovert = this.df.format(dataJson.getDate("alarmTime"));
        PerimeterVO vo = new PerimeterVO();
        vo.setUuid(UUID.randomUUID().toString());
        vo.setCategory(Integer.valueOf(1));
        vo.setDeviceSerial(deviceInfoVO.getSerial());
        vo.setDeviceName(deviceInfoVO.getSerial());
        vo.setName(dataJson.getString("sCIDDescribe"));
        vo.setLocation("\u9632\u533a" + dataJson.getString("wDefenceNo"));
        vo.setContent("\u9632\u533a" + dataJson.getString("wDefenceNo") + dataJson.getString("sCIDDescribe"));
        vo.setAlertAt(timeCovert);
        try {
            log.info("\u5468\u754c\u62a5\u8b66\u4e0a\u4f20\u5230\u8bbe\u5907\u7ba1\u7406\u5e73\u53f0\u7684\u6570\u636e\uff1a" + vo);
            HttpResponse response = this.httpUtils.httpSend(this.pickerConfig.getAlertTrigger(), "data", "alert_trigger", vo.getDeviceSerial(), timeCovert, JSONObject.toJSONString((Object)vo));
            log.info("\u5468\u754c\u62a5\u8b66\u4e0a\u4f20\u7ed3\u679c\uff1a" + EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }
}

