/*
 * Decompiled with CFR 0.152.
 */
package com.chuweizi.hiktool.sdk;

import com.alibaba.fastjson.JSONObject;
import com.chuweizi.hiktool.base.BeanUtils;
import com.chuweizi.hiktool.base.PickerCache;
import com.chuweizi.hiktool.picker.PickerService;
import com.chuweizi.hiktool.picker.pojo.DeviceInfoVO;
import com.chuweizi.hiktool.sdk.HCNetSDK;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMSGCallBackV31
implements HCNetSDK.FMSGCallBack_V31 {
    private static final Logger log = LoggerFactory.getLogger(FMSGCallBackV31.class);
    PickerService pickerService = (PickerService)BeanUtils.getBean((String)"pickerService");

    public boolean invoke(int lCommand, HCNetSDK.NET_DVR_ALARMER pAlarmer, Pointer pAlarmInfo, int dwBufLen, Pointer pUser) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        LocalDate day = LocalDate.now();
        String[] ipArr = new String(pAlarmer.sDeviceIP).split("\u0000", 2);
        String ip = ipArr[0];
        Date time = new Date();
        log.info("\u6293\u62cd\u8bbe\u5907ip\uff1a" + ip + "\u6293\u62cd\u65f6\u95f4\uff1a" + dateFormat.format(time));
        File fileBackground = null;
        JSONObject dataJson = new JSONObject();
        switch (lCommand) {
            case 4370: {
                HCNetSDK.NET_VCA_FACESNAP_RESULT netVcaFacesnapResult = new HCNetSDK.NET_VCA_FACESNAP_RESULT();
                netVcaFacesnapResult.write();
                Pointer pointerFace = netVcaFacesnapResult.getPointer();
                pointerFace.write(0L, pAlarmInfo.getByteArray(0L, netVcaFacesnapResult.size()), 0, netVcaFacesnapResult.size());
                netVcaFacesnapResult.read();
                fileBackground = new File("D:/caijiqi/hiktool/images/" + day + "/" + ((DeviceInfoVO)PickerCache.faceDeviceCache.get(ip)).getSerial() + "_background_" + format.format(time) + ".jpg");
                if (netVcaFacesnapResult.dwBackgroundPicLen > 0 && netVcaFacesnapResult.pBuffer2 != null) {
                    try {
                        FileOutputStream os = new FileOutputStream(fileBackground);
                        ByteBuffer byteBuffer = netVcaFacesnapResult.pBuffer2.getByteBuffer(0L, (long)netVcaFacesnapResult.dwBackgroundPicLen);
                        byte[] bytes = new byte[netVcaFacesnapResult.dwBackgroundPicLen];
                        byteBuffer.rewind();
                        byteBuffer.get(bytes);
                        os.write(bytes);
                        os.close();
                        log.info("\u4eba\u8138\u6293\u62cd\u56fe\u7247\u4fdd\u5b58\u6210\u529f\uff01" + fileBackground.getPath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                File fileFace = new File("D:/caijiqi/hiktool/images/" + day + "/" + ((DeviceInfoVO)PickerCache.faceDeviceCache.get(ip)).getSerial() + "_face_" + format.format(time) + ".jpg");
                if (netVcaFacesnapResult.dwFacePicLen > 0 && netVcaFacesnapResult.pBuffer1 != null) {
                    try {
                        FileOutputStream os = new FileOutputStream(fileFace);
                        ByteBuffer byteBuffer = netVcaFacesnapResult.pBuffer1.getByteBuffer(0L, (long)netVcaFacesnapResult.dwFacePicLen);
                        byte[] bytes = new byte[netVcaFacesnapResult.dwFacePicLen];
                        byteBuffer.rewind();
                        byteBuffer.get(bytes);
                        os.write(bytes);
                        os.close();
                        log.info("\u4eba\u8138\u6293\u62cd\u56fe\u7247\u4fdd\u5b58\u6210\u529f\uff01" + fileFace.getPath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                dataJson.put("ip", (Object)ip);
                dataJson.put("sex", (Object)netVcaFacesnapResult.struFeature.bySex);
                dataJson.put("time", (Object)new Date());
                dataJson.put("faceId", (Object)netVcaFacesnapResult.dwFacePicID);
                dataJson.put("similarity", (Object)netVcaFacesnapResult.dwFaceScore);
                this.pickerService.uploadPersonCapture(dataJson, fileBackground.getPath(), fileFace.getPath());
                break;
            }
            case 12368: {
                HCNetSDK.NET_ITS_PLATE_RESULT netItsPlateResult = new HCNetSDK.NET_ITS_PLATE_RESULT();
                netItsPlateResult.write();
                Pointer pointerCar = netItsPlateResult.getPointer();
                pointerCar.write(0L, pAlarmInfo.getByteArray(0L, netItsPlateResult.size()), 0, netItsPlateResult.size());
                netItsPlateResult.read();
                fileBackground = new File("D:/caijiqi/hiktool/images/" + day + "/" + ((DeviceInfoVO)PickerCache.vehicleDeviceCache.get(ip)).getSerial() + "_background_" + format.format(time) + ".jpg");
                for (HCNetSDK.NET_ITS_PICTURE_INFO netItsPictureInfo : netItsPlateResult.struPicInfo) {
                    if (netItsPictureInfo.dwDataLen == 0 || netItsPictureInfo.byType != 1) continue;
                    try {
                        FileOutputStream os = new FileOutputStream(fileBackground);
                        ByteBuffer byteBuffer = netItsPictureInfo.pBuffer.getByteBuffer(0L, (long)netItsPictureInfo.dwDataLen);
                        byte[] bytes = new byte[netItsPictureInfo.dwDataLen];
                        byteBuffer.rewind();
                        byteBuffer.get(bytes);
                        os.write(bytes);
                        os.close();
                        log.info("\u8f66\u8f86\u6293\u62cd\u56fe\u7247\u4fdd\u5b58\u6210\u529f\uff01");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                String plateNo = this.byteArrToString(netItsPlateResult.struPlateInfo.sLicense);
                dataJson.put("ip", (Object)ip);
                dataJson.put("time", (Object)new Date());
                dataJson.put("plateNo", (Object)plateNo);
                this.pickerService.uploadVehicleAccess(dataJson, fileBackground.getPath());
                break;
            }
            case 4391: {
                HCNetSDK.NET_DVR_CID_ALARM struCIDAlarmInfo = new HCNetSDK.NET_DVR_CID_ALARM();
                struCIDAlarmInfo.write();
                Pointer perimeter = struCIDAlarmInfo.getPointer();
                perimeter.write(0L, pAlarmInfo.getByteArray(0L, struCIDAlarmInfo.size()), 0, struCIDAlarmInfo.size());
                struCIDAlarmInfo.read();
                Date struTriggerTime = this.getStrTime(struCIDAlarmInfo.struTriggerTime);
                Date struUploadTime = this.getStrTime(struCIDAlarmInfo.struUploadTime);
                String sCIDCode = new String(struCIDAlarmInfo.sCIDCode);
                String sCIDDescribe = this.byteArrToString(struCIDAlarmInfo.sCIDDescribe);
                byte bySubSysNo = struCIDAlarmInfo.bySubSysNo;
                short wDefenceNo = struCIDAlarmInfo.wDefenceNo;
                dataJson.put("alarmTime", (Object)struTriggerTime);
                dataJson.put("uploadTime", (Object)struUploadTime);
                dataJson.put("sCIDCode", (Object)sCIDCode);
                dataJson.put("sCIDDescribe", (Object)sCIDDescribe);
                dataJson.put("bySubSysNo", (Object)bySubSysNo);
                dataJson.put("wDefenceNo", (Object)wDefenceNo);
                dataJson.put("ip", (Object)ip);
                this.pickerService.uploadPerimeterAlarm(dataJson);
                break;
            }
            case 16384: {
                HCNetSDK.NET_DVR_ALARMINFO_V30 netDvrAlarminfoV30 = new HCNetSDK.NET_DVR_ALARMINFO_V30();
                netDvrAlarminfoV30.write();
                Pointer pointerAlarm = netDvrAlarminfoV30.getPointer();
                pointerAlarm.write(0L, pAlarmInfo.getByteArray(0L, netDvrAlarminfoV30.size()), 0, netDvrAlarminfoV30.size());
                netDvrAlarminfoV30.read();
                log.info("\u62a5\u8b66\u7c7b\u578b\uff1a" + netDvrAlarminfoV30.dwAlarmType);
                break;
            }
            default: {
                log.info("\u5176\u4ed6\u62a5\u8b66\u7c7b\u578b\uff01");
            }
        }
        return true;
    }

    public String byteArrToString(byte[] bytes) {
        try {
            return new String(bytes, "GBK").trim();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Date getStrTime(HCNetSDK.NET_DVR_TIME_EX netDvrTimeEx) {
        StringBuffer sb = new StringBuffer();
        sb.append(netDvrTimeEx.wYear).append("-").append(netDvrTimeEx.byMonth).append("-").append(netDvrTimeEx.byDay).append(" ").append(netDvrTimeEx.byHour).append(":").append(netDvrTimeEx.byMinute).append(":").append(netDvrTimeEx.bySecond);
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(sb.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] Ref2Byte(ByteByReference buf, int dwBufSize) {
        byte[] byteArr = buf.getPointer().getByteArray(0L, dwBufSize);
        return byteArr;
    }

    public static String byte2Base64StringFun(byte[] b) {
        return Base64.encodeBase64String((byte[])b);
    }
}

