/*
 * Decompiled with CFR 0.152.
 */
package com.chuweizi.hiktool.sdk;

import com.chuweizi.hiktool.base.PickerCache;
import com.chuweizi.hiktool.picker.pojo.DeviceInfoVO;
import com.chuweizi.hiktool.sdk.FMSGCallBackV31;
import com.chuweizi.hiktool.sdk.HCNetSDK;
import com.sun.jna.Pointer;
import java.io.File;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikDeviceService {
    private static final Logger log = LoggerFactory.getLogger(HikDeviceService.class);
    static HCNetSDK hCNetSDK = HCNetSDK.INSTANCE;
    static FMSGCallBackV31 fMSFCallBack_V31;

    public static void initializeDevice(List<DeviceInfoVO> faceArr, List<DeviceInfoVO> vehicleArr, List<DeviceInfoVO> cameraArr, List<DeviceInfoVO> perimeterArr) {
        Pointer pUser;
        boolean init = hCNetSDK.NET_DVR_Init();
        if (init) {
            log.info("\u521d\u59cb\u5316SDK\u6210\u529f!");
        }
        hCNetSDK.NET_DVR_SetConnectTime(2000, 1);
        hCNetSDK.NET_DVR_SetReconnect(10000, true);
        File file = new File("D:/caijiqi/hiktool/images/" + LocalDate.now() + "/");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!hCNetSDK.NET_DVR_SetDVRMessageCallBack_V31((HCNetSDK.FMSGCallBack_V31)(fMSFCallBack_V31 = new FMSGCallBackV31()), pUser = null)) {
            log.warn("\u8bbe\u7f6e\u56de\u8c03\u51fd\u6570\u5931\u8d25!");
        } else {
            log.info("\u8bbe\u7f6e\u56de\u8c03\u51fd\u6570\u6210\u529f\uff01");
        }
        faceArr.forEach(face -> {
            HCNetSDK.NET_DVR_DEVICEINFO_V30 net_dvr_deviceinfo_v30 = new HCNetSDK.NET_DVR_DEVICEINFO_V30();
            int lUserID = hCNetSDK.NET_DVR_Login_V30(face.getIp(), Short.parseShort(face.getPort()), face.getUsername(), face.getPassword(), net_dvr_deviceinfo_v30);
            if (lUserID < 0) {
                log.warn("\u4eba\u8138\u6293\u62cd\u8bbe\u5907\u767b\u5f55\u5931\u8d25 ip=" + face.getIp() + "\u9519\u8bef\u4fe1\u606f:" + hCNetSDK.NET_DVR_GetLastError());
                return;
            }
            log.info("\u4eba\u8138\u6293\u62cd\u8bbe\u5907\u767b\u5f55\u6210\u529f\uff1aip=" + face.getIp());
            face.setLUserID(Integer.valueOf(lUserID));
            HCNetSDK.NET_DVR_SETUPALARM_PARAM struAlarmParam = new HCNetSDK.NET_DVR_SETUPALARM_PARAM();
            struAlarmParam.dwSize = struAlarmParam.size();
            struAlarmParam.byLevel = 1;
            struAlarmParam.byAlarmInfoType = 1;
            struAlarmParam.byDeployType = 1;
            struAlarmParam.write();
            int lAlarmHandle = hCNetSDK.NET_DVR_SetupAlarmChan_V41(lUserID, struAlarmParam);
            if (lAlarmHandle == -1) {
                log.warn("\u4eba\u8138\u6293\u62cd\u5e03\u9632\u5931\u8d25!");
                return;
            }
            log.info("\u4eba\u8138\u6293\u62cd\u5e03\u9632\u6210\u529f\uff1aip=" + face.getIp());
            ((DeviceInfoVO)PickerCache.faceDeviceCache.get(face.getIp())).setLUserID(Integer.valueOf(lUserID));
        });
        vehicleArr.forEach(hc -> {
            HCNetSDK.NET_DVR_DEVICEINFO_V30 net_dvr_deviceinfo_v30 = new HCNetSDK.NET_DVR_DEVICEINFO_V30();
            int lUserID = hCNetSDK.NET_DVR_Login_V30(hc.getIp(), Short.parseShort(hc.getPort()), hc.getUsername(), hc.getPassword(), net_dvr_deviceinfo_v30);
            if (lUserID < 0) {
                log.warn("\u8f66\u8f86\u6293\u62cd\u8bbe\u5907\u767b\u5f55\u5931\u8d25 ip=" + hc.getIp() + "\u9519\u8bef\u4fe1\u606f:" + hCNetSDK.NET_DVR_GetLastError());
                return;
            }
            log.info("\u8f66\u8f86\u6293\u62cd\u8bbe\u5907\u767b\u5f55\u6210\u529f\uff1aip=" + hc.getIp());
            hc.setLUserID(Integer.valueOf(lUserID));
            HCNetSDK.NET_DVR_SETUPALARM_PARAM struAlarmParam = new HCNetSDK.NET_DVR_SETUPALARM_PARAM();
            struAlarmParam.dwSize = struAlarmParam.size();
            struAlarmParam.byLevel = 1;
            struAlarmParam.byAlarmInfoType = 1;
            struAlarmParam.byDeployType = 1;
            struAlarmParam.write();
            int lAlarmHandle = hCNetSDK.NET_DVR_SetupAlarmChan_V41(lUserID, struAlarmParam);
            if (lAlarmHandle == -1) {
                log.warn("\u8f66\u8f86\u6293\u62cd\u5e03\u9632\u5931\u8d25!");
                return;
            }
            log.info("\u8f66\u8f86\u6293\u62cd\u5e03\u9632\u6210\u529f\uff1aip=" + hc.getIp());
            ((DeviceInfoVO)PickerCache.vehicleDeviceCache.get(hc.getIp())).setLUserID(Integer.valueOf(lUserID));
        });
        cameraArr.forEach(camera -> {
            HCNetSDK.NET_DVR_DEVICEINFO_V30 net_dvr_deviceinfo_v30 = new HCNetSDK.NET_DVR_DEVICEINFO_V30();
            int lUserID = hCNetSDK.NET_DVR_Login_V30(camera.getIp(), Short.parseShort(camera.getPort()), camera.getUsername(), camera.getPassword(), net_dvr_deviceinfo_v30);
            if (lUserID < 0) {
                log.warn("\u89c6\u9891\u76d1\u63a7\u8bbe\u5907\u767b\u5f55\u5931\u8d25 ip=" + camera.getIp() + "\u9519\u8bef\u4fe1\u606f:" + hCNetSDK.NET_DVR_GetLastError());
                return;
            }
            log.info("\u89c6\u9891\u76d1\u63a7\u8bbe\u5907\u767b\u5f55\u6210\u529f\uff1aip=" + camera.getIp());
            camera.setLUserID(Integer.valueOf(lUserID));
            ((DeviceInfoVO)PickerCache.cameraDeviceCache.get(camera.getIp())).setLUserID(Integer.valueOf(lUserID));
        });
        perimeterArr.forEach(perimeter -> {
            HCNetSDK.NET_DVR_DEVICEINFO_V30 net_dvr_deviceinfo_v30 = new HCNetSDK.NET_DVR_DEVICEINFO_V30();
            int lUserID = hCNetSDK.NET_DVR_Login_V30(perimeter.getIp(), Short.parseShort(perimeter.getPort()), perimeter.getUsername(), perimeter.getPassword(), net_dvr_deviceinfo_v30);
            if (lUserID < 0) {
                log.warn("\u5468\u754c\u9632\u62a4\u8bbe\u5907\u767b\u5f55\u5931\u8d25 ip=" + perimeter.getIp() + "\u9519\u8bef\u4fe1\u606f:" + hCNetSDK.NET_DVR_GetLastError());
                return;
            }
            log.info("\u5468\u754c\u9632\u62a4\u8bbe\u5907\u767b\u5f55\u6210\u529f\uff1aip=" + perimeter.getIp());
            perimeter.setLUserID(Integer.valueOf(lUserID));
            HCNetSDK.NET_DVR_SETUPALARM_PARAM struAlarmParam = new HCNetSDK.NET_DVR_SETUPALARM_PARAM();
            struAlarmParam.dwSize = struAlarmParam.size();
            struAlarmParam.byLevel = 1;
            struAlarmParam.byAlarmInfoType = 1;
            struAlarmParam.byDeployType = 1;
            struAlarmParam.write();
            int lAlarmHandle = hCNetSDK.NET_DVR_SetupAlarmChan_V41(lUserID, struAlarmParam);
            if (lAlarmHandle == -1) {
                log.warn("\u5468\u754c\u9632\u62a4\u5e03\u9632\u5931\u8d25!");
                return;
            }
            log.info("\u5468\u754c\u9632\u62a4\u5e03\u9632\u6210\u529f\uff1aip=" + perimeter.getIp());
            ((DeviceInfoVO)PickerCache.perimeterDeviceCache.get(perimeter.getIp())).setLUserID(Integer.valueOf(lUserID));
        });
    }
}

