/*
 * Decompiled with CFR 0.152.
 */
package com.chuweizi.hiktool.base;

import com.alibaba.fastjson.JSONObject;
import com.chuweizi.hiktool.base.PickerConfig;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    @Autowired
    PickerConfig pickerConfig;

    public String getPhotoUrl(String path) {
        log.info("\u56fe\u7247\u8def\u5f84\uff1a" + path);
        RestTemplate restTemplate = new RestTemplate();
        File file = new File(path);
        LinkedMultiValueMap paramMap = new LinkedMultiValueMap();
        paramMap.add((Object)"file", (Object)new FileSystemResource(file));
        paramMap.add((Object)"uploaderType", (Object)"minio");
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.MULTIPART_FORM_DATA);
        org.springframework.http.HttpEntity httpEntity = new org.springframework.http.HttpEntity((Object)paramMap, (MultiValueMap)header);
        JSONObject response = (JSONObject)restTemplate.postForObject(this.pickerConfig.getFileHost(), (Object)httpEntity, JSONObject.class, new Object[0]);
        if (response != null && response.getIntValue("code") == 200) {
            return response.getJSONObject("data").getString("url");
        }
        return "";
    }

    public HttpResponse httpSend(String api, String type, String code, String serial, String timeCovert, String data) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String reqId = this.pickerConfig.getKey() + "-" + System.currentTimeMillis();
        paramMap.put("type", type);
        paramMap.put("code", code);
        paramMap.put("sender", this.pickerConfig.getKey());
        paramMap.put("region", this.pickerConfig.getRegion());
        paramMap.put("device", serial);
        paramMap.put("requestId", reqId);
        String param = "";
        paramMap.put("data", (String)JSONObject.parseObject((String)data));
        String jsonString = JSONObject.toJSONString(paramMap);
        String sn = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, this.pickerConfig.getSecret()).hmacHex(api + "|" + timeCovert + "|" + param.trim() + "|" + jsonString);
        HttpPost post = new HttpPost(this.pickerConfig.getHost() + api);
        post.setHeader("sender", this.pickerConfig.getKey());
        post.setHeader("sentAt", timeCovert);
        post.setHeader("reqId", reqId);
        post.setHeader("sign", sn);
        post.setHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)new StringEntity(jsonString, "utf-8"));
        CloseableHttpClient client = HttpClients.createDefault();
        HttpResponse response = client.execute((HttpUriRequest)post);
        return response;
    }
}

