/*
 * Decompiled with CFR 0.152.
 */
package com.chuweizi.hiktool.picker;

import com.alibaba.fastjson.JSONObject;
import com.chuweizi.hiktool.base.HttpUtils;
import com.chuweizi.hiktool.base.PickerCache;
import com.chuweizi.hiktool.base.PickerConfig;
import com.chuweizi.hiktool.sdk.HCNetSDK;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DeviceTask {
    private static final Logger log = LoggerFactory.getLogger(DeviceTask.class);
    static HCNetSDK hCNetSDK = HCNetSDK.INSTANCE;
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    @Autowired
    PickerConfig pickerConfig;
    @Autowired
    HttpUtils httpUtils;

    @Scheduled(cron="0 0/30 * * * ?")
    public void syncDeviceStatus() {
        log.info("\u5f00\u59cb\u540c\u6b65\u8bbe\u5907\u72b6\u6001\uff01");
        ArrayList list = new ArrayList();
        list.addAll(PickerCache.faceDeviceCache.values());
        list.addAll(PickerCache.vehicleDeviceCache.values());
        list.addAll(PickerCache.cameraDeviceCache.values());
        list.addAll(PickerCache.perimeterDeviceCache.values());
        HCNetSDK.NET_DVR_WORKSTATE_V30 netDvrWorkstateV30 = new HCNetSDK.NET_DVR_WORKSTATE_V30();
        list.forEach(device -> {
            hCNetSDK.NET_DVR_GetDVRWorkState_V30(device.getLUserID().intValue(), netDvrWorkstateV30);
            JSONObject data = new JSONObject();
            if (netDvrWorkstateV30.dwDeviceStatic == 0) {
                data.put("status", (Object)1);
            } else if (netDvrWorkstateV30.dwDeviceStatic == 1) {
                data.put("status", (Object)1);
                data.put("message", (Object)"CPU\u5360\u7528\u7387\u592a\u9ad8,\u8d85\u8fc785%");
            } else {
                data.put("status", (Object)3);
                data.put("message", (Object)"\u786c\u4ef6\u6545\u969c");
            }
            try {
                HttpResponse response = this.httpUtils.httpSend(this.pickerConfig.getDeviceStatus(), "device", "device_status", device.getSerial(), this.df.format(new Date()), data.toJSONString());
                log.info("\u8bbe\u5907" + device.getSerial() + "\u72b6\u6001\u6570\u636e\u4e0a\u62a5\uff1a" + data + " \u4e0a\u62a5\u7ed3\u679c\uff1a" + EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error(e.getMessage());
            }
        });
    }

    @Scheduled(cron="5 0 0 * * ? ")
    public void clearImages() throws IOException {
        LocalDate day = LocalDate.now();
        File file = new File("D:/caijiqi/hiktool/images/" + day + "/");
        file.mkdir();
        File oldFile = new File("D:/caijiqi/hiktool/images/" + day.plusWeeks(-2L) + "/");
        if (oldFile.exists()) {
            FileUtils.deleteDirectory((File)oldFile);
        }
    }

    @Scheduled(cron="0 0/10 * * * ?")
    public void DeleteFileDate() {
        log.info("\u5f00\u59cb\u5220\u966410\u5206\u949f\u524d\u89c6\u9891\u6587\u4ef6\uff01");
        Date date = new Date(System.currentTimeMillis() - 600000L);
        File video = new File("D:/caijiqi/easydarwin/video/");
        File[] deviceArr = video.listFiles();
        for (int i = 0; i < deviceArr.length; ++i) {
            File device = deviceArr[i];
            File[] dayArr = device.listFiles();
            if (dayArr.length == 0) {
                device.delete();
                continue;
            }
            for (int j = 0; j < dayArr.length; ++j) {
                File day = dayArr[j];
                File[] fileArr = day.listFiles();
                if (fileArr.length == 0) {
                    day.delete();
                    continue;
                }
                log.info("\u76ee\u5f55\uff1a" + day.getPath() + " \u5f00\u59cb\u6e05\u7406!");
                for (int k = 0; k < fileArr.length; ++k) {
                    File file = fileArr[k];
                    if (!new Date(file.lastModified()).before(date)) continue;
                    file.delete();
                }
            }
        }
    }
}

