/*
 * Decompiled with CFR 0.152.
 */
package com.chuweizi.hiktool.picker;

import com.alibaba.fastjson.JSONObject;
import com.chuweizi.hiktool.base.BeanUtils;
import com.chuweizi.hiktool.base.CategoryType;
import com.chuweizi.hiktool.picker.PickerService;
import com.chuweizi.hiktool.picker.pojo.DeviceInfoVO;
import com.chuweizi.hiktool.sdk.HikDeviceService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class ServiceStarted
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(ServiceStarted.class);
    PickerService pickerService = (PickerService)BeanUtils.getBean((String)"pickerService");

    public void run(ApplicationArguments args) {
        String content;
        File file = new File("device.json");
        JSONObject json = null;
        if (file.exists()) {
            content = null;
            try {
                content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            log.info("\u8bbe\u5907\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230");
            return;
        }
        json = JSONObject.parseObject((String)content);
        HashMap map = new HashMap();
        ArrayList faceArr = JSONObject.parseArray((String)json.getString(CategoryType.face.name()), DeviceInfoVO.class);
        if (faceArr == null || faceArr.size() == 0) {
            log.warn("\u4eba\u8138\u6293\u62cd\u8bbe\u5907\u672a\u914d\u7f6e\uff01");
            faceArr = new ArrayList();
        } else {
            map.put(CategoryType.face.name(), faceArr);
        }
        ArrayList vehicleArr = JSONObject.parseArray((String)json.getString(CategoryType.vehicle.name()), DeviceInfoVO.class);
        if (vehicleArr == null || vehicleArr.size() == 0) {
            log.warn("\u8f66\u8f86\u6293\u62cd\u8bbe\u5907\u672a\u914d\u7f6e\uff01");
            vehicleArr = new ArrayList();
        } else {
            map.put(CategoryType.vehicle.name(), vehicleArr);
        }
        ArrayList cameraArr = JSONObject.parseArray((String)json.getString(CategoryType.camera.name()), DeviceInfoVO.class);
        if (cameraArr == null || cameraArr.size() == 0) {
            log.warn("\u89c6\u9891\u76d1\u63a7\u8bbe\u5907\u672a\u914d\u7f6e\uff01");
            cameraArr = new ArrayList();
        } else {
            map.put(CategoryType.camera.name(), cameraArr);
        }
        ArrayList perimeterArr = JSONObject.parseArray((String)json.getString(CategoryType.perimeter.name()), DeviceInfoVO.class);
        if (perimeterArr == null || perimeterArr.size() == 0) {
            log.warn("\u5468\u754c\u9632\u62a4\u8bbe\u5907\u672a\u914d\u7f6e\uff01");
            perimeterArr = new ArrayList();
        } else {
            map.put(CategoryType.perimeter.name(), perimeterArr);
        }
        this.pickerService.deviceAdd(map);
        HikDeviceService.initializeDevice(faceArr, vehicleArr, cameraArr, perimeterArr);
    }
}

