/*
 * Decompiled with CFR 0.152.
 */
package com.github.cgdon.fqueue;

import com.github.cgdon.fqueue.exception.FileEOFException;
import com.github.cgdon.fqueue.exception.FileFormatException;
import com.github.cgdon.fqueue.internal.Entity;
import com.github.cgdon.fqueue.internal.Index;
import java.io.File;
import java.io.IOException;

public class FSQueue {
    private int entityLimitLength;
    private String path = null;
    private Index idx = null;
    private Entity writerHandle = null;
    private Entity readerHandle = null;
    private int readerIndex = -1;
    private int writerIndex = -1;

    public FSQueue(String dir) throws IOException, FileFormatException {
        this(new File(dir));
    }

    public FSQueue(String dir, int entityLimitLength) throws IOException, FileFormatException {
        this(new File(dir), entityLimitLength);
    }

    public FSQueue(File dir) throws IOException, FileFormatException {
        this(dir, 0x200000);
    }

    public FSQueue(File dir, int entityLimitLength) throws IOException, FileFormatException {
        if (!(dir.exists() || dir.isDirectory() || dir.mkdirs())) {
            throw new IOException("create dir error");
        }
        this.entityLimitLength = entityLimitLength;
        this.path = dir.getAbsolutePath();
        this.idx = new Index(this.path);
        this.initHandle();
    }

    private void initHandle() throws IOException, FileFormatException {
        this.writerIndex = this.idx.getWriterIndex();
        this.readerIndex = this.idx.getReaderIndex();
        this.writerHandle = new Entity(this.path, this.writerIndex, this.entityLimitLength, this.idx);
        this.readerHandle = this.readerIndex == this.writerIndex ? this.writerHandle : new Entity(this.path, this.readerIndex, this.entityLimitLength, this.idx);
    }

    private void rotateNextLogWriter() throws IOException, FileFormatException {
        ++this.writerIndex;
        this.writerHandle.putNextFileNumber(this.writerIndex);
        if (this.readerHandle != this.writerHandle) {
            this.writerHandle.close();
        }
        this.idx.putWriterIndex(this.writerIndex);
        this.writerHandle = new Entity(this.path, this.writerIndex, this.entityLimitLength, this.idx, true);
    }

    public void add(String message) throws IOException, FileFormatException {
        this.add(message.getBytes());
    }

    public void add(byte[] message) throws IOException, FileFormatException {
        short status = this.writerHandle.write(message);
        if (status == 3) {
            this.rotateNextLogWriter();
            status = this.writerHandle.write(message);
        }
        if (status == 1) {
            this.idx.incrementSize();
        }
    }

    private byte[] read(boolean commit) throws IOException, FileFormatException {
        byte[] bytes = null;
        try {
            bytes = this.readerHandle.read(commit);
        }
        catch (FileEOFException e) {
            int nextFileNumber = this.readerHandle.getNextFileNumber();
            this.readerHandle.reset();
            File deleteFile = this.readerHandle.getFile();
            this.readerHandle.close();
            deleteFile.delete();
            this.idx.putReaderPosition(Entity.MESSAGE_START_POSITION);
            this.idx.putReaderIndex(nextFileNumber);
            this.readerHandle = this.writerHandle.getCurrentFileNumber() == nextFileNumber ? this.writerHandle : new Entity(this.path, nextFileNumber, this.entityLimitLength, this.idx);
            try {
                bytes = this.readerHandle.read(commit);
            }
            catch (FileEOFException e1) {
                throw new FileFormatException(e1);
            }
        }
        if (bytes != null && commit) {
            this.idx.decrementSize();
        }
        return bytes;
    }

    public byte[] readNext() throws IOException, FileFormatException {
        return this.read(false);
    }

    public byte[] readNextAndRemove() throws IOException, FileFormatException {
        return this.read(true);
    }

    public void clear() throws IOException, FileFormatException {
        this.idx.clear();
        this.initHandle();
    }

    public void close() throws IOException {
        this.readerHandle.close();
        this.writerHandle.close();
        this.idx.close();
    }

    public int getQueueSize() {
        return this.idx.getSize();
    }
}

