/*
 * Decompiled with CFR 0.152.
 */
package com.github.cgdon.fqueue.internal;

import com.github.cgdon.fqueue.exception.FileEOFException;
import com.github.cgdon.fqueue.exception.FileFormatException;
import com.github.cgdon.fqueue.internal.Index;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class Entity {
    public static final byte WRITESUCCESS = 1;
    public static final byte WRITEFAILURE = 2;
    public static final byte WRITEFULL = 3;
    public static final String MAGIC = "FQueuefs";
    private static final String DB_FILE_PREFIX = "fq_";
    private static final String DB_FILE_SUFFIX = ".db";
    public static int MESSAGE_START_POSITION = 20;
    private File file;
    private RandomAccessFile raFile;
    private FileChannel fc;
    private MappedByteBuffer mappedByteBuffer;
    private Index idx = null;
    private int fileLimitLength;
    private String magicString = null;
    private int version = -1;
    private int readerPosition = -1;
    private int writerPosition = -1;
    private int endPosition = -1;
    private int currentFileNumber = -1;
    private int nextFileNumber = -1;

    public Entity(String path, int fileNumber, int fileLimitLength, Index db) throws IOException, FileFormatException {
        this(path, fileNumber, fileLimitLength, db, false);
    }

    public Entity(String path, int fileNumber, int fileLimitLength, Index idx, boolean create) throws IOException, FileFormatException {
        this.currentFileNumber = fileNumber;
        this.fileLimitLength = fileLimitLength;
        this.idx = idx;
        this.file = Entity.getIdbFile(path, fileNumber);
        if (!this.file.exists() || create) {
            this.createLogEntity();
        } else {
            this.raFile = new RandomAccessFile(this.file, "rwd");
            int fileLength = (int)this.raFile.length();
            if (fileLength < MESSAGE_START_POSITION) {
                throw new FileFormatException("file format error");
            }
            if (fileLimitLength < fileLength) {
                fileLimitLength = fileLength;
                this.fileLimitLength = fileLength;
            }
            this.fc = this.raFile.getChannel();
            this.mappedByteBuffer = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, fileLimitLength);
            byte[] bytes = new byte[8];
            this.mappedByteBuffer.get(bytes);
            this.magicString = new String(bytes);
            if (!this.magicString.equals(MAGIC)) {
                throw new FileFormatException("file format error");
            }
            this.version = this.mappedByteBuffer.getInt();
            this.nextFileNumber = this.mappedByteBuffer.getInt();
            this.endPosition = this.mappedByteBuffer.getInt();
            this.writerPosition = this.endPosition == -1 ? idx.getWriterPosition() : this.endPosition;
            this.readerPosition = idx.getReaderIndex() == this.currentFileNumber ? idx.getReaderPosition() : MESSAGE_START_POSITION;
        }
        Thread t = new Thread(new Sync());
        t.setDaemon(true);
        t.start();
    }

    public static File getIdbFile(String path, int fileNumber) {
        return new File(path, DB_FILE_PREFIX + fileNumber + DB_FILE_SUFFIX);
    }

    public int getCurrentFileNumber() {
        return this.currentFileNumber;
    }

    public int getNextFileNumber() {
        return this.nextFileNumber;
    }

    private boolean createLogEntity() throws IOException {
        this.raFile = new RandomAccessFile(this.file, "rwd");
        this.raFile.setLength(0L);
        this.fc = this.raFile.getChannel();
        this.mappedByteBuffer = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, this.fileLimitLength);
        this.mappedByteBuffer.put(MAGIC.getBytes());
        this.mappedByteBuffer.putInt(this.version);
        this.mappedByteBuffer.putInt(this.nextFileNumber);
        this.mappedByteBuffer.putInt(this.endPosition);
        this.magicString = MAGIC;
        this.writerPosition = MESSAGE_START_POSITION;
        this.readerPosition = MESSAGE_START_POSITION;
        this.idx.putWriterPosition(this.writerPosition);
        return true;
    }

    public void reset() throws IOException {
        this.version = -1;
        this.endPosition = -1;
        this.currentFileNumber = -1;
        this.nextFileNumber = -1;
        this.mappedByteBuffer.position(0);
        this.mappedByteBuffer.put(MAGIC.getBytes());
        this.mappedByteBuffer.putInt(this.version);
        this.mappedByteBuffer.putInt(this.nextFileNumber);
        this.mappedByteBuffer.putInt(this.endPosition);
        this.mappedByteBuffer.force();
        this.magicString = MAGIC;
        this.writerPosition = MESSAGE_START_POSITION;
        this.readerPosition = MESSAGE_START_POSITION;
    }

    public void putNextFileNumber(int number) throws IOException {
        this.mappedByteBuffer.position(12);
        this.mappedByteBuffer.putInt(number);
        this.nextFileNumber = number;
    }

    public boolean isFull(int increment) {
        return this.fileLimitLength < this.writerPosition + increment;
    }

    public byte write(byte[] bytes) throws IOException {
        int increment = bytes.length + 4;
        if (this.isFull(increment)) {
            this.mappedByteBuffer.position(16);
            this.mappedByteBuffer.putInt(this.writerPosition);
            this.endPosition = this.writerPosition;
            return 3;
        }
        this.mappedByteBuffer.position(this.writerPosition);
        this.mappedByteBuffer.putInt(bytes.length);
        this.mappedByteBuffer.put(bytes);
        this.writerPosition += increment;
        this.idx.putWriterPosition(this.writerPosition);
        return 1;
    }

    public byte[] read(boolean commit) throws IOException, FileEOFException {
        if (this.endPosition != -1 && this.readerPosition >= this.endPosition) {
            throw new FileEOFException("file eof");
        }
        if (this.readerPosition >= this.writerPosition) {
            return null;
        }
        this.mappedByteBuffer.position(this.readerPosition);
        int length = this.mappedByteBuffer.getInt();
        byte[] bytes = new byte[length];
        this.mappedByteBuffer.get(bytes);
        if (commit) {
            this.readerPosition += length + 4;
            this.idx.putReaderPosition(this.readerPosition);
        }
        return bytes;
    }

    public byte[] read() throws IOException, FileEOFException {
        return this.read(true);
    }

    public File getFile() {
        return this.file;
    }

    public void close() throws IOException {
        if (this.mappedByteBuffer == null) {
            return;
        }
        this.mappedByteBuffer.force();
        this.mappedByteBuffer = null;
        this.fc.close();
        this.raFile.close();
    }

    public String headerInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(" magicString:");
        sb.append(this.magicString);
        sb.append(" version:");
        sb.append(this.version);
        sb.append(" readerPosition:");
        sb.append(this.readerPosition);
        sb.append(" writerPosition:");
        sb.append(this.writerPosition);
        sb.append(" nextFileNumber:");
        sb.append(this.nextFileNumber);
        sb.append(" endPosition:");
        sb.append(this.endPosition);
        sb.append(" currentFileNumber:");
        sb.append(this.currentFileNumber);
        return sb.toString();
    }

    private class Sync
    implements Runnable {
        private Sync() {
        }

        @Override
        public void run() {
            while (Entity.this.mappedByteBuffer != null) {
                try {
                    Entity.this.mappedByteBuffer.force();
                }
                catch (Exception e) {
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

