/*
 * Decompiled with CFR 0.152.
 */
package net.hrtn.xhgd.MQServer;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.Envelope;
import java.util.List;
import java.util.Map;
import net.hrtn.xhgd.access.mq.MQCommand;

public class RabbitMQServer {
    static Log log = LogFactory.get();
    String userName = "";
    String password = "";
    String virtualHost = "/";
    String hostName = "";
    int portNumber = -1;
    ConnectionFactory factory = null;
    Connection mqConnection = null;
    Channel callbackChannel = null;
    String publishRoute = "";

    public void setDefaultPublishRoute(String publishRoute) {
        this.publishRoute = publishRoute;
    }

    public RabbitMQServer(String host, String user, String pwd, String virtualHost, Integer port) throws Exception {
        if (!StrUtil.isNotEmpty((CharSequence)host)) {
            throw new Exception("\u8fde\u63a5host\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.hostName = StrUtil.trim((CharSequence)host);
        if (!StrUtil.isNotEmpty((CharSequence)user)) {
            throw new Exception("\u8fde\u63a5\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.userName = StrUtil.trim((CharSequence)user);
        if (!StrUtil.isNotEmpty((CharSequence)pwd)) {
            throw new Exception("\u8fde\u63a5\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.password = StrUtil.trim((CharSequence)pwd);
        this.virtualHost = StrUtil.isNotEmpty((CharSequence)virtualHost) ? StrUtil.trim((CharSequence)virtualHost) : "/";
        this.portNumber = null != port && port > 0 ? port : 5672;
        this.factory = new ConnectionFactory();
        this.factory.setUsername(this.userName);
        this.factory.setPassword(this.password);
        this.factory.setVirtualHost(this.virtualHost);
        this.factory.setHost(this.hostName);
        this.factory.setPort(this.portNumber);
        this.factory.setAutomaticRecoveryEnabled(true);
    }

    public RabbitMQServer initCallback(String queue, List<MQReceive> receives) throws Exception {
        this.mqConnection = this.factory.newConnection();
        this.callbackChannel = this.mqConnection.createChannel();
        this.callbackChannel.basicQos(1);
        DeliverCallback deliverCallback = (consumerTag, delivery) -> {
            Envelope envelope = delivery.getEnvelope();
            String _exchange = envelope.getExchange();
            String _routingKey = envelope.getRoutingKey();
            long _deliveryTag = envelope.getDeliveryTag();
            AMQP.BasicProperties properties = delivery.getProperties();
            Map headers = properties.getHeaders();
            String expiredAt = StrUtil.str(headers.get("expiredAt"), (String)"UTF-8");
            String sentAt = StrUtil.str(headers.get("sentAt"), (String)"UTF-8");
            boolean hasHandle = false;
            String message = new String(delivery.getBody(), "UTF-8");
            log.debug("MQ message = {}", new Object[]{JSONUtil.toJsonPrettyStr((Object)Dict.create().set("envelope", (Object)envelope).set("_exchange", (Object)_exchange).set("_routingKey", (Object)_routingKey).set("_deliveryTag", (Object)_deliveryTag).set("properties", (Object)properties).set("headers", (Object)headers).set("expiredAt", (Object)expiredAt).set("sentAt", (Object)sentAt).set("message", (Object)JSONUtil.parseObj((String)message)))});
            for (MQReceive receive : receives) {
                try {
                    MQCommand command = (MQCommand)JSONUtil.toBean((String)message, (TypeReference)new TypeReference<MQCommand<JSONObject>>(){}, (boolean)true);
                    hasHandle = receive.receive(command);
                    if (!hasHandle) continue;
                    break;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), new Object[0]);
                }
            }
            if (!hasHandle) {
                log.debug("\u6536\u5230\u672a\u5b9a\u4e49\u7684\u5904\u7406\u6570\u636e,data=[{}]", new Object[]{message});
            }
        };
        this.callbackChannel.basicConsume(queue, true, deliverCallback, consumerTag -> {});
        return this;
    }

    public void close() {
        if (null != this.callbackChannel) {
            try {
                this.callbackChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.mqConnection) {
            try {
                this.mqConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface MQReceive {
        public boolean receive(MQCommand<JSONObject> var1);
    }
}

