/*
 * Decompiled with CFR 0.152.
 */
package net.hrtn.xhgd.command;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.hrtn.xhgd.access.dto.AckDTO;
import net.hrtn.xhgd.access.dto.CommandDTO;
import net.hrtn.xhgd.access.dto.DeviceAddDTO;
import net.hrtn.xhgd.access.dto.DeviceStatusDTO;
import net.hrtn.xhgd.access.dto.PersonAccessDTO;
import net.hrtn.xhgd.access.dto.PersonInfoDTO;
import net.hrtn.xhgd.access.dto.data.Access;
import net.hrtn.xhgd.access.dto.data.Handle;
import net.hrtn.xhgd.access.dto.data.PersonInfo;
import net.hrtn.xhgd.access.dto.data.Register;
import net.hrtn.xhgd.access.dto.data.Trigger;
import net.hrtn.xhgd.access.dto.data.alert_handle;
import net.hrtn.xhgd.access.dto.data.alert_trigger;
import net.hrtn.xhgd.access.dto.data.device_data;
import net.hrtn.xhgd.command.HttpResult;
import net.hrtn.xhgd.command.HttpSender;
import net.hrtn.xhgd.command.ImgUploadResult;
import net.hrtn.xhgd.config.BaseConfig;
import net.hrtn.xhgd.config.PlatformsConfig;

public class GDCommandService {
    static Log log = LogFactory.get();
    BaseConfig baseConfig = new BaseConfig();
    PlatformsConfig platformsConfig = new PlatformsConfig();
    public static final String AtTimeFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    public static String getAtTimeFormat() {
        return GDCommandService.getAtTimeFormat((Date)DateUtil.date());
    }

    public static String getAtTimeFormat(Date date) {
        return DateUtil.format((Date)date, (String)AtTimeFormat);
    }

    public boolean postDeviceAdd(String deviceSerial, String category, String deviceName) {
        return this.postDeviceAdd(deviceSerial, this.baseConfig.getDistrict(), category, deviceName);
    }

    public boolean postDeviceAdd(String deviceSerial, String region, String category, String deviceName) {
        return this.postDeviceAdd(deviceSerial, region, this.baseConfig.getClientKey(), category, deviceName);
    }

    public boolean postDeviceAdd(String deviceSerial, String region, String sender, String category, String deviceName) {
        String reqId = this.requestId();
        DeviceAddDTO ds = new DeviceAddDTO();
        ds.setRequestId(reqId).setDevice(deviceSerial).setRegion(region).setSender(sender);
        Register httpRegister = new Register().setCategory(category).setName(deviceName).setRegion(region).setSerial(deviceSerial).setStatus(1);
        ds.setData(BeanUtil.beanToMap((Object)httpRegister, (boolean)false, (boolean)true));
        log.info("[{}]\u5c0f\u533a\u65b0\u8bbe\u5907[{}]\u6ce8\u518c\u4e2d\u3002\u3002\u3002", new Object[]{httpRegister.getRegion(), httpRegister.getName()});
        HttpResult result = HttpSender.post(reqId, null, this.platformsConfig.getPostDeviceAdd(), JSONUtil.toJsonStr((Object)ds));
        log.info("[{}]\u5c0f\u533a\u65b0\u8bbe\u5907[{}]\u6ce8\u518c{}\u3002", new Object[]{httpRegister.getRegion(), httpRegister.getName(), result.getCode() == 200 ? "\u6210\u529f" : "\u5931\u8d25: " + result.html});
        return 200 == result.getCode();
    }

    public void commandFeedback(String code, String result, int progress, int total, String message, String device, String requestId) {
        this.commandFeedback(this.baseConfig.getDistrict(), code, result, progress, total, message, device, requestId);
    }

    public void commandFeedback(String district, String code, String result, int progress, int total, String message, String device, String requestId) {
        this.commandFeedback(district, this.baseConfig.getClientKey(), code, result, progress, total, message, device, requestId);
    }

    public void commandFeedback(String district, String clientKey, String code, String result, int progress, int total, String message, String device, String requestId) {
        this.commandFeedback(district, clientKey, code, result, progress, total, message, device, requestId, null);
    }

    public <T> void commandFeedback(String code, String result, int progress, int total, String message, String device, String requestId, T data) {
        this.commandFeedback(this.baseConfig.getDistrict(), code, result, progress, total, message, device, requestId, data);
    }

    public <T> void commandFeedback(String district, String code, String result, int progress, int total, String message, String device, String requestId, T data) {
        this.commandFeedback(district, this.baseConfig.getClientKey(), code, result, progress, total, message, device, requestId, data);
    }

    public <T> void commandFeedback(String district, String clientKey, String code, String result, int progress, int total, String message, String device, String requestId, T data) {
        CommandDTO command = new CommandDTO().setStartedAt(GDCommandService.getAtTimeFormat()).setFinishedAt(GDCommandService.getAtTimeFormat()).setProgress(progress).setTotal(total).setResult(result).setMessage(message).setData(data);
        String reqId = this.requestId();
        AckDTO ack = new AckDTO();
        ack.setCommand(code).setData(BeanUtil.beanToMap(command, (boolean)false, (boolean)true)).setDevice(device).setRegion(district).setSourceId(requestId).setRequestId(reqId).setSender(clientKey);
        String sendJson = JSONUtil.toJsonStr((Object)ack);
        HttpResult _result = HttpSender.post(reqId, null, ack.url(), sendJson);
        log.info("\u6307\u4ee4\u53cd\u9988: {}", new Object[]{JSONUtil.toJsonPrettyStr((Object)_result)});
    }

    public <T> void commandFeedback(String district, String clientKey, String code, String result, int progress, int total, String message, String device, String requestId, T data, String type, String url) {
        CommandDTO command = new CommandDTO().setStartedAt(GDCommandService.getAtTimeFormat()).setFinishedAt(GDCommandService.getAtTimeFormat()).setProgress(progress).setTotal(total).setResult(result).setMessage(message).setData(data);
        String reqId = this.requestId();
        AckDTO ack = new AckDTO();
        ack.setCommand(code).setData(BeanUtil.beanToMap(command, (boolean)false, (boolean)true)).setDevice(device).setRegion(district).setSourceId(requestId).setRequestId(reqId).setSender(clientKey).setType(type);
        String sendJson = JSONUtil.toJsonStr((Object)ack);
        HttpResult _result = HttpSender.post(reqId, null, this.platformsConfig.getValueByKey(url), sendJson);
        log.info("\u6307\u4ee4\u53cd\u9988: {}", new Object[]{JSONUtil.toJsonPrettyStr((Object)_result)});
    }

    public boolean postDeviceStatus(String deviceSerial, String category, String deviceName, int status) {
        return this.postDeviceStatus(deviceSerial, this.baseConfig.getDistrict(), category, deviceName, status);
    }

    public boolean postDeviceStatus(String deviceSerial, String district, String category, String deviceName, int status) {
        return this.postDeviceStatus(deviceSerial, district, this.baseConfig.getClientKey(), category, deviceName, status);
    }

    public boolean postDeviceStatus(String deviceSerial, String region, String sender, String category, String deviceName, int status) {
        String requestId = this.requestId();
        DeviceStatusDTO ds = new DeviceStatusDTO();
        ds.setDevice(deviceSerial).setRegion(region).setRequestId(requestId).setSender(sender);
        Register register = new Register().setRegion(region).setCategory(category).setSerial(deviceSerial).setName(deviceName).setStatus(status);
        ds.setData(BeanUtil.beanToMap((Object)register, (boolean)false, (boolean)true));
        log.info("[{}]\u5c0f\u533a\u8bbe\u5907[{}]\u72b6\u6001\u66f4\u65b0\u4e2d\u3002\u3002\u3002", new Object[]{register.getRegion(), register.getName()});
        HttpResult result = HttpSender.post(requestId, null, this.platformsConfig.getPostDeviceStatus(), JSONUtil.toJsonStr((Object)ds));
        log.info("[{}]\u5c0f\u533a\u65b0\u8bbe\u5907[{}]\u72b6\u6001\u66f4\u65b0{}\u3002", new Object[]{register.getRegion(), register.getName(), result.getCode() == 200 ? "\u6210\u529f" : "\u5931\u8d25: " + result.html});
        return 200 == result.getCode();
    }

    public boolean postAccessInfo(String sender, String idCode, String idType, String deviceSerial, String deviceName, String image, String accessedAt, String district, String methodDict, String method) {
        String accessName = this.getPersonName(idType, idCode, sender, district, deviceSerial);
        Access access = new Access().setName(accessName).setIdCode(idCode).setIdType(idType).setDeviceSerial(deviceSerial).setDeviceName(deviceName).setImage(image).setAccessedAt(accessedAt).setDistrict(district).setMethod(method).setMethodDict(methodDict);
        Map data = BeanUtil.beanToMap((Object)access, (boolean)false, (boolean)true);
        String requestId = this.requestId();
        PersonAccessDTO pa = new PersonAccessDTO();
        pa.setRequestId(requestId).setSender(sender).setRegion(district).setDevice(deviceSerial).setData(data);
        log.info("[{}]\u5c0f\u533a\u8bbe\u5907[{}  {}]\u51fa\u5165\u4eba\u5458[{}]\u4e0a\u62a5\u4e2d\u3002\u3002\u3002", new Object[]{district, deviceName, deviceSerial, idCode});
        HttpResult result = HttpSender.post(requestId, null, pa.url(), JSONUtil.toJsonStr((Object)pa));
        log.info("[{}]\u5c0f\u533a\u8bbe\u5907[{}  {}]\u51fa\u5165\u4eba\u5458[{}]\u4e0a\u62a5{}\u3002", new Object[]{district, deviceName, deviceSerial, idCode, result.getCode() == 200 ? "\u6210\u529f" : "\u5931\u8d25: " + result.html});
        return result.getCode() == 200;
    }

    public Boolean postData(Map dataMap, String device, String region, String requestId, String sender) {
        device_data ds = new device_data();
        ds.setData(dataMap).setDevice(device).setRegion(region).setRequestId(requestId).setSender(sender);
        log.info("\u4e0a\u62a5\u7684\u8bbe\u5907\u8bfb\u6570\uff1a{}", new Object[]{JSONUtil.toJsonPrettyStr((Object)ds)});
        HttpResult result = HttpSender.post(requestId, null, this.platformsConfig.getPostDataUrl(), JSONUtil.toJsonStr((Object)ds));
        if (ObjectUtil.isEmpty((Object)result)) {
            log.info("\u4e0a\u62a5\u7684\u8bbe\u5907\u8bfb\u6570\u7684\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{result});
            return false;
        }
        log.info("\u4e0a\u62a5\u7684\u8bbe\u5907\u8bfb\u6570\u7684\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{JSONUtil.isJson((String)result.getHtml()) ? JSONUtil.toJsonPrettyStr((Object)result.getHtml()) : result.getHtml()});
        if (result.getCode() == 200) {
            return true;
        }
        return false;
    }

    public Boolean reportAlarmData(String region, Integer category, String deviceSerial, String deviceName, String name, String alertAt, String content, String requestId, String sender) {
        Trigger trigger = new Trigger();
        trigger.setUuid(IdUtil.fastSimpleUUID()).setCategory(category).setDeviceSerial(deviceSerial).setDeviceName(deviceName).setName(name).setAlertAt(alertAt).setLocation(null).setContent(content);
        alert_trigger ds = new alert_trigger();
        ds.setData(BeanUtil.beanToMap((Object)trigger, (boolean)false, (boolean)true)).setDevice(deviceSerial).setRegion(region).setRequestId(requestId).setSender(sender);
        HttpResult result = HttpSender.post(requestId, null, this.platformsConfig.getReportAlarmDataUrl(), JSONUtil.toJsonStr((Object)ds));
        log.info("\u8bbe\u5907snCode\uff1a{}\uff0c\u4e0a\u62a5\u7684\u62a5\u8b66\u6570\u636e\uff1a{}", new Object[]{deviceSerial, JSONUtil.toJsonPrettyStr((Object)ds)});
        log.info("\u4e0a\u62a5\u7684\u544a\u8b66\u6570\u636e\u7684\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{JSONUtil.isJson((String)result.getHtml()) ? JSONUtil.toJsonPrettyStr((Object)result.getHtml()) : result.getHtml()});
        if (result.getCode() == 200) {
            return true;
        }
        return false;
    }

    public Boolean reportCancelAlarmData(String region, String deviceSerial, String name, String alertAt, String requestId, String sender) {
        Handle handle = new Handle();
        handle.setUuid(IdUtil.fastSimpleUUID()).setHandler(name).setNote("\u6d88\u8b66").setHandleAt(alertAt);
        alert_handle ds = new alert_handle();
        ds.setData(BeanUtil.beanToMap((Object)handle, (boolean)false, (boolean)true)).setDevice(deviceSerial).setRegion(region).setRequestId(requestId).setSender(sender);
        HttpResult result = HttpSender.post(requestId, null, this.platformsConfig.getReportCancelAlarmUrl(), JSONUtil.toJsonStr((Object)ds));
        log.info("\u8bbe\u5907snCode\uff1a{}\uff0c\u4e0a\u62a5\u7684\u6d88\u8b66\u6570\u636e\uff1a{}", new Object[]{deviceSerial, JSONUtil.toJsonPrettyStr((Object)ds)});
        log.info("\u4e0a\u62a5\u7684\u6d88\u8b66\u6570\u636e\u7684\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{JSONUtil.isJson((String)result.getHtml()) ? JSONUtil.toJsonPrettyStr((Object)result.getHtml()) : result.getHtml()});
        if (result.getCode() == 200) {
            return true;
        }
        return false;
    }

    public String uploadImg2GD(File imgFile) {
        return this.uploadImg2GD(imgFile, "");
    }

    public String uploadImg2GD(File imgFile, String ttl) {
        String _url = this.platformsConfig.getImgUpload();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("file", imgFile);
        paramMap.put("ttl", StrUtil.isNotBlank((CharSequence)ttl) ? ttl : "180d");
        ImgUploadResult result = (ImgUploadResult)JSONUtil.toBean((String)HttpUtil.post((String)_url, paramMap, (int)10000), ImgUploadResult.class);
        String url = "";
        if (200 == result.getCode() && 200 == result.getStatus() && StrUtil.equals((CharSequence)"success", (CharSequence)result.getMessage(), (boolean)true)) {
            url = result.getData().getUrl();
        } else {
            log.error("\u56fe\u7247\u4e0a\u4f20\u6570\u636e\u4e2d\u5fc3\u5931\u8d25: {}", new Object[]{result});
        }
        return url;
    }

    public String getPersonName(String idType, String idCode, String sender, String region, String device) {
        String name = "\u8bbf\u5ba2";
        if (StrUtil.isBlank((CharSequence)idCode) || StrUtil.isBlank((CharSequence)idType)) {
            return name;
        }
        PersonInfo personInfo = new PersonInfo().setIdCode(idCode).setCode(region).setIdType(idType);
        Map data = BeanUtil.beanToMap((Object)personInfo, (boolean)false, (boolean)true);
        PersonInfoDTO pr = new PersonInfoDTO();
        pr.setRequestId(this.requestId()).setSender(sender).setRegion(region).setDevice(device).setData(data);
        String json = JSONUtil.toJsonStr((Object)BeanUtil.beanToMap((Object)pr, (boolean)false, (boolean)true));
        HttpResult result = HttpSender.post(pr.getRequestId(), null, pr.url(), json);
        Object _name = JSONUtil.parseObj((String)result.getHtml()).getByPath("data[0].name");
        return _name == null ? name : String.valueOf(_name);
    }

    public Map<String, String> getPersonNameZjg(String idType, String idCode, String sender, String region, String device) {
        LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>();
        String name = "\u8bbf\u5ba2";
        if (StrUtil.isBlank((CharSequence)idCode)) {
            returnMap.put("name", name);
            return returnMap;
        }
        PersonInfo personInfo = new PersonInfo().setIdCode(idCode).setCode(region).setIdType(idType);
        Map data = BeanUtil.beanToMap((Object)personInfo, (boolean)false, (boolean)true);
        PersonInfoDTO pr = new PersonInfoDTO();
        pr.setRequestId(this.requestId()).setSender(sender).setRegion(region).setDevice(device).setData(data);
        String json = JSONUtil.toJsonStr((Object)BeanUtil.beanToMap((Object)pr, (boolean)false, (boolean)true));
        HttpResult result = HttpSender.post(pr.getRequestId(), null, this.platformsConfig.getPostPersonInfoUrl(), json);
        Object _name = JSONUtil.parseObj((String)result.getHtml()).getByPath("data[0].name");
        if (ObjectUtil.isNotEmpty((Object)_name)) {
            returnMap.put("name", _name.toString());
        } else {
            returnMap.put("name", name);
        }
        Object _idType = JSONUtil.parseObj((String)result.getHtml()).getByPath("data[0].idType");
        if (ObjectUtil.isNotEmpty((Object)_idType)) {
            returnMap.put("idType", _idType.toString());
        } else {
            returnMap.put("idType", "11");
        }
        return returnMap;
    }

    public String requestId() {
        return StrUtil.format((CharSequence)"{}-{}", (Object[])new Object[]{this.baseConfig.getClientKey(), IdUtil.fastSimpleUUID()});
    }

    public boolean postAccessInfoV2(String sender, String idCode, String idType, String deviceSerial, String deviceName, String image, String accessedAt, String district, String methodDict, String method, String name) {
        Access access = new Access().setName(name).setIdCode(idCode).setIdType(idType).setDeviceSerial(deviceSerial).setDeviceName(deviceName).setImage(image).setAccessedAt(accessedAt).setDistrict(district).setMethod(method).setMethodDict(methodDict);
        Map data = BeanUtil.beanToMap((Object)access, (boolean)false, (boolean)true);
        String requestId = this.requestId();
        PersonAccessDTO pa = new PersonAccessDTO();
        pa.setRequestId(requestId).setSender(sender).setRegion(district).setDevice(deviceSerial).setData(data);
        log.info("[{}]\u5c0f\u533a\u8bbe\u5907[{}  {}]\u51fa\u5165\u4eba\u5458[{}]\u4e0a\u62a5\u4e2d\u3002\u3002\u3002", new Object[]{district, deviceName, deviceSerial, idCode});
        HttpResult result = HttpSender.post(requestId, null, pa.url(), JSONUtil.toJsonStr((Object)pa));
        log.info("[{}]\u5c0f\u533a\u8bbe\u5907[{}  {}]\u51fa\u5165\u4eba\u5458[{}]\u4e0a\u62a5{}\u3002", new Object[]{district, deviceName, deviceSerial, idCode, result.getCode() == 200 ? "\u6210\u529f" : "\u5931\u8d25: " + result.html});
        return result.getCode() == 200;
    }
}

