/*
 * Decompiled with CFR 0.152.
 */
package net.hrtn.xhgd.command;

import cn.hutool.core.lang.Dict;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.hrtn.xhgd.command.GDCommandService;
import net.hrtn.xhgd.command.HttpResult;
import net.hrtn.xhgd.command.SignTool;
import net.hrtn.xhgd.config.BaseConfig;
import net.hrtn.xhgd.config.PlatformsConfig;

public class HttpSender {
    static Log log = LogFactory.get();

    public static HttpResult post(String reqId, Date expiredAt, String url, Object param) {
        return HttpSender.post(reqId, expiredAt, url, param, 5000);
    }

    public static HttpResult post(String reqId, Date expiredAt, String url, Object param, int timeout) {
        String json = "";
        if (param instanceof String) {
            if (JSONUtil.isJson((String)((String)param))) {
                json = (String)param;
            }
        } else {
            json = JSONUtil.toJsonStr((Object)param);
        }
        return HttpSender.post(reqId, expiredAt, url, json, timeout);
    }

    public static HttpResult post(String reqId, Date expiredAt, String url, String postJson, int timeout) {
        String sentAt = "";
        sentAt = null != expiredAt ? GDCommandService.getAtTimeFormat(expiredAt) : GDCommandService.getAtTimeFormat();
        BaseConfig baseConfig = new BaseConfig();
        String REQ = SignTool.REQ(url, sentAt, "", postJson);
        String SECRET = baseConfig.getSECRET();
        String sign = SignTool.sign(REQ, SECRET);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("sender", baseConfig.getClientKey());
        headers.put("sentAt", sentAt);
        headers.put("reqId", reqId);
        if (null != expiredAt) {
            headers.put("expiredAt", sentAt);
        }
        headers.put("sign", sign);
        PlatformsConfig platformsConfig = new PlatformsConfig();
        String _url = platformsConfig.getPostRootUrl() + url;
        HttpResponse response = null;
        HttpResult result = null;
        try {
            response = ((HttpRequest)new HttpRequest(_url).method(Method.POST).headerMap(headers, true)).body(postJson).timeout(timeout).execute();
            if (null != response) {
                String html = response.body();
                if (JSONUtil.isJson((String)html)) {
                    JSONObject htmlObj = JSONUtil.parseObj((String)html);
                    result = new HttpResult().setCheckSign(response.isOk()).setCode(htmlObj.getInt((Object)"code")).setStatus(htmlObj.getInt((Object)"status")).setMessage(htmlObj.getStr((Object)"message")).setHtml(html);
                    Map resultMap = (Map)JSONUtil.toBean((String)response.body(), HashMap.class, (boolean)true);
                    result.setSourceId(htmlObj.getStr((Object)"sourceId"));
                    result.setRequestId(htmlObj.getStr((Object)"requestId"));
                } else {
                    result = new HttpResult().setHtml(html);
                    log.debug("{}:\u8bf7\u6c42\u8fd4\u56de\u7684\u9519\u8bef\u7ed3\u679c:{}", new Object[]{url, response});
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        log.debug("{}\u8bf7\u6c42\u8be6\u60c5:{}", new Object[]{url, JSONUtil.toJsonPrettyStr((Object)Dict.create().set("header", headers).set("url", (Object)_url).set("body", (Object)postJson).set("result", result))});
        return result;
    }
}

