/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.aop;

import com.jfinal.aop.Inject;
import com.jfinal.aop.Singleton;
import com.jfinal.core.Controller;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.proxy.Proxy;
import com.jfinal.validate.Validator;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class AopFactory {
    protected ConcurrentHashMap<Class<?>, Object> singletonCache = new ConcurrentHashMap();
    protected ThreadLocal<HashMap<Class<?>, Object>> singletonTl = ThreadLocal.withInitial(() -> new HashMap());
    protected ThreadLocal<HashMap<Class<?>, Object>> prototypeTl = ThreadLocal.withInitial(() -> new HashMap());
    protected HashMap<Class<?>, Class<?>> mapping = null;
    protected boolean singleton = true;
    protected boolean injectSuperClass = false;

    public <T> T get(Class<T> targetClass) {
        try {
            return this.doGet(targetClass);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T doGet(Class<T> targetClass) throws ReflectiveOperationException {
        boolean singleton;
        Singleton si = (targetClass = this.getMappingClass(targetClass)).getAnnotation(Singleton.class);
        boolean bl = singleton = si != null ? si.value() : this.singleton;
        if (singleton) {
            return (T)this.doGetSingleton(targetClass);
        }
        return (T)this.doGetPrototype(targetClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doGetSingleton(Class<T> targetClass) throws ReflectiveOperationException {
        Object ret = this.singletonCache.get(targetClass);
        if (ret != null) {
            return (T)ret;
        }
        HashMap<Class<?>, Object> map = this.singletonTl.get();
        int size = map.size();
        if (size > 0 && (ret = map.get(targetClass)) != null) {
            return (T)ret;
        }
        AopFactory aopFactory = this;
        synchronized (aopFactory) {
            ret = this.singletonCache.get(targetClass);
            if (ret == null) {
                ret = this.createObject(targetClass);
                map.put(targetClass, ret);
                this.doInject(targetClass, ret);
                this.singletonCache.put(targetClass, ret);
            }
            Object object = ret;
            return (T)object;
            finally {
                if (size == 0) {
                    this.singletonTl.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doGetPrototype(Class<T> targetClass) throws ReflectiveOperationException {
        Object ret;
        HashMap<Class<?>, Object> map = this.prototypeTl.get();
        int size = map.size();
        if (size > 0 && (ret = map.get(targetClass)) != null) {
            return (T)this.createObject(targetClass);
        }
        try {
            ret = this.createObject(targetClass);
            map.put(targetClass, ret);
            this.doInject(targetClass, ret);
            Object object = ret;
            return (T)object;
        }
        finally {
            if (size == 0) {
                map.clear();
            }
        }
    }

    public <T> T inject(T targetObject) {
        try {
            this.doInject(targetObject.getClass(), targetObject);
            return targetObject;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T inject(Class<T> targetClass, T targetObject) {
        try {
            this.doInject(targetClass, targetObject);
            return targetObject;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doInject(Class<?> targetClass, Object targetObject) throws ReflectiveOperationException {
        Class<?> c;
        Field[] fields = (targetClass = this.getUsefulClass(targetClass)).getDeclaredFields();
        if (fields.length != 0) {
            for (Field field : fields) {
                Inject inject = field.getAnnotation(Inject.class);
                if (inject == null) continue;
                Class<?> fieldInjectedClass = inject.value();
                if (fieldInjectedClass == Void.class) {
                    fieldInjectedClass = field.getType();
                }
                Object fieldInjectedObject = this.doGet(fieldInjectedClass);
                field.setAccessible(true);
                field.set(targetObject, fieldInjectedObject);
            }
        }
        if (this.injectSuperClass && (c = targetClass.getSuperclass()) != Controller.class && c != Object.class && c != Validator.class && c != Model.class && c != null) {
            this.doInject(c, targetObject);
        }
    }

    protected Object createObject(Class<?> targetClass) throws ReflectiveOperationException {
        return Proxy.get(targetClass);
    }

    protected Class<?> getUsefulClass(Class<?> clazz) {
        return clazz.getName().indexOf("$$EnhancerBy") == -1 ? clazz : clazz.getSuperclass();
    }

    public AopFactory setSingleton(boolean singleton) {
        this.singleton = singleton;
        return this;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public AopFactory setInjectSuperClass(boolean injectSuperClass) {
        this.injectSuperClass = injectSuperClass;
        return this;
    }

    public boolean isInjectSuperClass() {
        return this.injectSuperClass;
    }

    public AopFactory addSingletonObject(Class<?> type, Object singletonObject) {
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        if (singletonObject == null) {
            throw new IllegalArgumentException("singletonObject can not be null");
        }
        if (singletonObject instanceof Class) {
            throw new IllegalArgumentException("singletonObject can not be Class type");
        }
        if (!type.isAssignableFrom(singletonObject.getClass())) {
            throw new IllegalArgumentException(singletonObject.getClass().getName() + " can not cast to " + type.getName());
        }
        if (this.singletonCache.putIfAbsent(type, singletonObject) != null) {
            throw new RuntimeException("Singleton object already exists for type : " + type.getName());
        }
        return this;
    }

    public AopFactory addSingletonObject(Object singletonObject) {
        Class<?> type = this.getUsefulClass(singletonObject.getClass());
        return this.addSingletonObject(type, singletonObject);
    }

    public synchronized <T> AopFactory addMapping(Class<T> from, Class<? extends T> to) {
        if (from == null || to == null) {
            throw new IllegalArgumentException("The parameter from and to can not be null");
        }
        if (this.mapping == null) {
            this.mapping = new HashMap(128, 0.25f);
        } else if (this.mapping.containsKey(from)) {
            throw new RuntimeException("Class already mapped : " + from.getName());
        }
        this.mapping.put(from, to);
        return this;
    }

    public <T> AopFactory addMapping(Class<T> from, String to) {
        try {
            Class<?> toClass = Class.forName(to.trim());
            if (from.isAssignableFrom(toClass)) {
                return this.addMapping(from, toClass);
            }
            throw new IllegalArgumentException("The parameter \"to\" must be the subclass or implementation of the parameter \"from\"");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getMappingClass(Class<?> from) {
        if (this.mapping != null) {
            Class<?> ret = this.mapping.get(from);
            return ret != null ? ret : from;
        }
        return from;
    }
}

