/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.aop;

import com.jfinal.aop.Aop;
import com.jfinal.aop.AopManager;
import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.aop.InvocationWrapper;
import java.util.ArrayList;
import java.util.List;

public abstract class InterceptorStack
implements Interceptor {
    private Interceptor[] inters;
    private List<Interceptor> interList;

    public InterceptorStack() {
        this.config();
        if (this.interList == null) {
            throw new RuntimeException("You must invoke addInterceptors(...) to config your InterceptorStack");
        }
        this.inters = this.interList.toArray(new Interceptor[this.interList.size()]);
        this.interList.clear();
        this.interList = null;
    }

    protected InterceptorStack addInterceptors(Interceptor ... interceptors) {
        if (interceptors == null || interceptors.length == 0) {
            throw new IllegalArgumentException("Interceptors can not be null");
        }
        if (this.interList == null) {
            this.interList = new ArrayList<Interceptor>();
        }
        for (Interceptor ref : interceptors) {
            if (AopManager.me().isInjectDependency()) {
                Aop.inject(ref);
            }
            this.interList.add(ref);
        }
        return this;
    }

    @Override
    public final void intercept(Invocation inv) {
        new InvocationWrapper(inv, this.inters).invoke();
    }

    public abstract void config();
}

