/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.aop.Aop;
import com.jfinal.aop.Invocation;
import com.jfinal.config.Constants;
import com.jfinal.core.Action;
import com.jfinal.core.ActionException;
import com.jfinal.core.ActionMapping;
import com.jfinal.core.ActionReporter;
import com.jfinal.core.Controller;
import com.jfinal.core.ControllerFactory;
import com.jfinal.core.ForwardActionRender;
import com.jfinal.handler.Handler;
import com.jfinal.kit.ReflectKit;
import com.jfinal.log.Log;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ActionHandler
extends Handler {
    protected boolean devMode;
    protected boolean injectDependency;
    protected ActionMapping actionMapping;
    protected ControllerFactory controllerFactory;
    protected static final RenderManager renderManager = RenderManager.me();
    private static final Log log = Log.getLog(ActionHandler.class);

    protected void init(ActionMapping actionMapping, Constants constants) {
        this.actionMapping = actionMapping;
        this.devMode = constants.getDevMode();
        this.injectDependency = constants.getInjectDependency();
        this.controllerFactory = constants.getControllerFactory();
    }

    protected Action getAction(String target, String[] urlPara) {
        return this.actionMapping.getAction(target, urlPara);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.indexOf(46) != -1) {
            return;
        }
        isHandled[0] = true;
        String[] urlPara = new String[]{null};
        Action action = this.getAction(target, urlPara);
        if (action == null) {
            if (log.isWarnEnabled()) {
                String qs = request.getQueryString();
                log.warn("404 Action Not Found: " + (qs == null ? target : target + "?" + qs));
            }
            renderManager.getRenderFactory().getErrorRender(404).setContext(request, response).render();
            return;
        }
        Controller controller = null;
        try {
            controller = this.controllerFactory.getController(action.getControllerClass());
            if (this.injectDependency) {
                Aop.inject(controller);
            }
            controller._init_(action, request, response, urlPara[0]);
            if (this.devMode) {
                if (ActionReporter.isReportAfterInvocation(request)) {
                    new Invocation(action, controller).invoke();
                    ActionReporter.report(target, controller, action);
                } else {
                    ActionReporter.report(target, controller, action);
                    new Invocation(action, controller).invoke();
                }
            } else {
                new Invocation(action, controller).invoke();
            }
            Render render = controller.getRender();
            if (render instanceof ForwardActionRender) {
                String actionUrl = ((ForwardActionRender)render).getActionUrl();
                if (target.equals(actionUrl)) {
                    throw new RuntimeException("The forward action url is the same as before.");
                }
                this.handle(actionUrl, request, response, isHandled);
                return;
            }
            if (render == null) {
                render = renderManager.getRenderFactory().getDefaultRender(action.getViewPath() + action.getMethodName());
            }
            render.setContext(request, response, action.getViewPath()).render();
        }
        catch (RenderException e) {
            if (log.isErrorEnabled()) {
                String qs = request.getQueryString();
                log.error(qs == null ? target : target + "?" + qs, e);
            }
        }
        catch (ActionException e) {
            this.handleActionException(target, request, response, action, e);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                String qs = request.getQueryString();
                String targetInfo = qs == null ? target : target + "?" + qs;
                String sign = ReflectKit.getMethodSignature(action.getMethod());
                log.error(sign + " : " + targetInfo, e);
            }
            renderManager.getRenderFactory().getErrorRender(500).setContext(request, response, action.getViewPath()).render();
        }
        finally {
            this.controllerFactory.recycle(controller);
        }
    }

    private void handleActionException(String target, HttpServletRequest request, HttpServletResponse response, Action action, ActionException e) {
        int errorCode = e.getErrorCode();
        String msg = null;
        if (errorCode == 404) {
            msg = "404 Not Found: ";
        } else if (errorCode == 400) {
            msg = "400 Bad Request: ";
        } else if (errorCode == 401) {
            msg = "401 Unauthorized: ";
        } else if (errorCode == 403) {
            msg = "403 Forbidden: ";
        }
        if (msg != null) {
            if (log.isWarnEnabled()) {
                String qs = request.getQueryString();
                msg = msg + (qs == null ? target : target + "?" + qs);
                if (e.getMessage() != null) {
                    msg = msg + "\n" + e.getMessage();
                }
                log.warn(msg);
            }
        } else if (log.isErrorEnabled()) {
            String qs = request.getQueryString();
            log.error(errorCode + " Error: " + (qs == null ? target : target + "?" + qs), e);
        }
        e.getErrorRender().setContext(request, response, action.getViewPath()).render();
    }
}

