/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core.converter;

import com.jfinal.core.converter.IConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class Converters {
    private static final String timeStampPattern = "yyyy-MM-dd HH:mm:ss";
    private static final String datePattern = "yyyy-MM-dd";
    private static final int dateLen = "yyyy-MM-dd".length();
    private static final int timeStampWithoutSecPatternLen = "yyyy-MM-dd HH:mm".length();
    private static final int timePatternLen = "hh:mm:ss".length();
    private static final int timeWithoutSecPatternLen = "hh:mm".length();

    private Converters() {
    }

    public static String supportHtml5DateTimePattern(String s) {
        if (s.indexOf(32) == -1 && s.indexOf(84) != -1 && s.indexOf(45) != -1 && s.indexOf(58) != -1) {
            return s.replace("T", " ");
        }
        return s;
    }

    public static class TimestampConverter
    implements IConverter<Timestamp> {
        @Override
        public Timestamp convert(String s) throws ParseException {
            s = Converters.supportHtml5DateTimePattern(s);
            if (timeStampWithoutSecPatternLen == s.length()) {
                s = s + ":00";
            }
            if (s.length() > dateLen) {
                return Timestamp.valueOf(s);
            }
            return new Timestamp(new SimpleDateFormat(Converters.datePattern).parse(s).getTime());
        }
    }

    public static class TimeConverter
    implements IConverter<Time> {
        @Override
        public Time convert(String s) throws ParseException {
            int len = s.length();
            if (len == timeWithoutSecPatternLen) {
                s = s + ":00";
            }
            if (len > timePatternLen) {
                s = s.substring(0, timePatternLen);
            }
            return Time.valueOf(s);
        }
    }

    public static class SqlDateConverter
    implements IConverter<Date> {
        @Override
        public Date convert(String s) throws ParseException {
            s = Converters.supportHtml5DateTimePattern(s);
            if (timeStampWithoutSecPatternLen == s.length()) {
                s = s + ":00";
            }
            if (s.length() > dateLen) {
                return new Date(new SimpleDateFormat(Converters.timeStampPattern).parse(s).getTime());
            }
            return new Date(new SimpleDateFormat(Converters.datePattern).parse(s).getTime());
        }
    }

    public static class DateConverter
    implements IConverter<java.util.Date> {
        @Override
        public java.util.Date convert(String s) throws ParseException {
            s = Converters.supportHtml5DateTimePattern(s);
            if (timeStampWithoutSecPatternLen == s.length()) {
                s = s + ":00";
            }
            if (s.length() > dateLen) {
                return new SimpleDateFormat(Converters.timeStampPattern).parse(s);
            }
            return new SimpleDateFormat(Converters.datePattern).parse(s);
        }
    }

    public static class BooleanConverter
    implements IConverter<Boolean> {
        @Override
        public Boolean convert(String s) {
            String value = s.toLowerCase();
            if ("true".equals(value) || "1".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value) || "0".equals(value)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Can not parse to boolean type of value: " + s);
        }
    }

    public static class BigDecimalConverter
    implements IConverter<BigDecimal> {
        @Override
        public BigDecimal convert(String s) {
            return new BigDecimal(s);
        }
    }

    public static class BigIntegerConverter
    implements IConverter<BigInteger> {
        @Override
        public BigInteger convert(String s) {
            return new BigInteger(s);
        }
    }

    public static class ByteArrayConverter
    implements IConverter<byte[]> {
        @Override
        public byte[] convert(String s) {
            return s.getBytes();
        }
    }

    public static class DoubleConverter
    implements IConverter<Double> {
        @Override
        public Double convert(String s) {
            return Double.parseDouble(s);
        }
    }

    public static class FloatConverter
    implements IConverter<Float> {
        @Override
        public Float convert(String s) {
            return Float.valueOf(Float.parseFloat(s));
        }
    }

    public static class LongConverter
    implements IConverter<Long> {
        @Override
        public Long convert(String s) {
            return Long.parseLong(s);
        }
    }

    public static class ByteConverter
    implements IConverter<Byte> {
        @Override
        public Byte convert(String s) {
            return Byte.parseByte(s);
        }
    }

    public static class ShortConverter
    implements IConverter<Short> {
        @Override
        public Short convert(String s) {
            return Short.parseShort(s);
        }
    }

    public static class IntegerConverter
    implements IConverter<Integer> {
        @Override
        public Integer convert(String s) {
            return Integer.parseInt(s);
        }
    }
}

