/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core.paragetter;

import com.jfinal.core.Action;
import com.jfinal.core.Controller;
import com.jfinal.core.paragetter.FileGetter;
import com.jfinal.core.paragetter.IParaGetter;
import com.jfinal.core.paragetter.UploadFileGetter;

public class ParaProcessor
implements IParaGetter<Object[]> {
    private int fileParaIndex = -1;
    private IParaGetter<?>[] paraGetters;

    public ParaProcessor(int paraCount) {
        this.paraGetters = paraCount > 0 ? new IParaGetter[paraCount] : null;
    }

    public void addParaGetter(int index, IParaGetter<?> paraGetter) {
        if (this.fileParaIndex == -1 && (paraGetter instanceof FileGetter || paraGetter instanceof UploadFileGetter)) {
            this.fileParaIndex = index;
        }
        this.paraGetters[index] = paraGetter;
    }

    @Override
    public Object[] get(Action action, Controller c) {
        int len = this.paraGetters.length;
        Object[] ret = new Object[len];
        if (this.fileParaIndex == -1) {
            for (int i = 0; i < len; ++i) {
                ret[i] = this.paraGetters[i].get(action, c);
            }
            return ret;
        }
        Object fileRet = this.paraGetters[this.fileParaIndex].get(action, c);
        for (int i = 0; i < len; ++i) {
            ret[i] = i != this.fileParaIndex ? this.paraGetters[i].get(action, c) : fileRet;
        }
        return ret;
    }
}

