/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.cors;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.ext.cors.EnableCORS;
import com.jfinal.kit.StrKit;
import javax.servlet.http.HttpServletResponse;

public class CORSInterceptor
implements Interceptor {
    private static final String METHOD_OPTIONS = "OPTIONS";

    @Override
    public void intercept(Invocation inv) {
        EnableCORS enableCORS = this.getAnnotation(inv);
        if (enableCORS == null) {
            inv.invoke();
            return;
        }
        this.doConfigCORS(inv, enableCORS);
        String method = inv.getController().getRequest().getMethod();
        if (METHOD_OPTIONS.equals(method)) {
            inv.getController().renderText("");
        } else {
            inv.invoke();
        }
    }

    private EnableCORS getAnnotation(Invocation inv) {
        EnableCORS enableCORS = inv.getController().getClass().getAnnotation(EnableCORS.class);
        return enableCORS != null ? enableCORS : inv.getMethod().getAnnotation(EnableCORS.class);
    }

    private void doConfigCORS(Invocation inv, EnableCORS enableCORS) {
        HttpServletResponse response = inv.getController().getResponse();
        String allowOrigin = enableCORS.allowOrigin();
        String allowCredentials = enableCORS.allowCredentials();
        String allowHeaders = enableCORS.allowHeaders();
        String allowMethods = enableCORS.allowMethods();
        String exposeHeaders = enableCORS.exposeHeaders();
        String requestHeaders = enableCORS.requestHeaders();
        String requestMethod = enableCORS.requestMethod();
        String origin = enableCORS.origin();
        String maxAge = enableCORS.maxAge();
        response.setHeader("Access-Control-Allow-Origin", allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", allowMethods);
        response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        response.setHeader("Access-Control-Max-Age", maxAge);
        response.setHeader("Access-Control-Allow-Credentials", allowCredentials);
        if (StrKit.notBlank(exposeHeaders)) {
            response.setHeader("Access-Control-Expose-Headers", exposeHeaders);
        }
        if (StrKit.notBlank(requestHeaders)) {
            response.setHeader("Access-Control-Request-Headers", requestHeaders);
        }
        if (StrKit.notBlank(requestMethod)) {
            response.setHeader("Access-Control-Request-Method", requestMethod);
        }
        if (StrKit.notBlank(origin)) {
            response.setHeader("Origin", origin);
        }
    }
}

