/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.proxy;

import com.jfinal.aop.Interceptor;
import com.jfinal.ext.proxy.CglibCallback;
import com.jfinal.kit.SyncWriteMap;
import com.jfinal.proxy.ProxyFactory;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

public class CglibProxyFactory
extends ProxyFactory {
    @Override
    public <T> T get(Class<T> target) {
        return (T)Enhancer.create(target, (Callback)new CglibCallback());
    }

    static class MethodKey {
        final int classHash;
        final int methodHash;
        final long paraHash;

        MethodKey(int classHash, int methodHash, long paraHash) {
            this.classHash = classHash;
            this.methodHash = methodHash;
            this.paraHash = paraHash;
        }

        public int hashCode() {
            return this.classHash ^ this.methodHash ^ (int)this.paraHash;
        }

        public boolean equals(Object methodKey) {
            MethodKey mk = (MethodKey)methodKey;
            return this.classHash == mk.classHash && this.methodHash == mk.methodHash && this.paraHash == mk.paraHash;
        }

        public String toString() {
            return "classHash = " + this.classHash + "\nmethodHash = " + this.methodHash + "\nparaHash = " + this.paraHash;
        }
    }

    static class IntersCache {
        private static final Map<MethodKey, Interceptor[]> cache = new SyncWriteMap<MethodKey, Interceptor[]>(2048, 0.25f);

        IntersCache() {
        }

        public static void put(MethodKey methodKey, Interceptor[] inters) {
            Objects.requireNonNull(methodKey, "methodKey can not be null");
            Objects.requireNonNull(inters, "inters can not be null");
            cache.putIfAbsent(methodKey, inters);
        }

        public static Interceptor[] get(MethodKey methodKey) {
            return cache.get(methodKey);
        }

        public static MethodKey getMethodKey(Class<?> target, Method method) {
            Class<?>[] paraTypes;
            long paraHash = -3750763034362895579L;
            for (Class<?> pt : paraTypes = method.getParameterTypes()) {
                paraHash ^= (long)pt.getName().hashCode();
                paraHash *= 1099511628211L;
            }
            return new MethodKey(target.getName().hashCode(), method.getName().hashCode(), paraHash);
        }
    }
}

