/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.log;

import com.jfinal.log.Log;
import com.jfinal.log.LogInfo;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdkLog
extends Log {
    private Logger log;
    private String clazzName;

    JdkLog(Class<?> clazz) {
        this.log = Logger.getLogger(clazz.getName());
        this.clazzName = clazz.getName();
    }

    JdkLog(String name) {
        this.log = Logger.getLogger(name);
        this.clazzName = name;
    }

    public static JdkLog getLog(Class<?> clazz) {
        return new JdkLog(clazz);
    }

    public static JdkLog getLog(String name) {
        return new JdkLog(name);
    }

    @Override
    public void trace(String message) {
        this.log.logp(Level.FINEST, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.log.logp(Level.FINEST, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public void debug(String message) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public void info(String message) {
        this.log.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public void warn(String message) {
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public void error(String message) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public void fatal(String message) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.isTraceEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.trace(li.message, li.throwable);
            } else {
                this.trace(String.format(format, args));
            }
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.debug(li.message, li.throwable);
            } else {
                this.debug(String.format(format, args));
            }
        }
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.info(li.message, li.throwable);
            } else {
                this.info(String.format(format, args));
            }
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.isWarnEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.warn(li.message, li.throwable);
            } else {
                this.warn(String.format(format, args));
            }
        }
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.isErrorEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.error(li.message, li.throwable);
            } else {
                this.error(String.format(format, args));
            }
        }
    }

    @Override
    public void fatal(String format, Object ... args) {
        if (this.isFatalEnabled()) {
            if (this.endsWithThrowable(args)) {
                LogInfo li = this.parse(format, args);
                this.fatal(li.message, li.throwable);
            } else {
                this.fatal(String.format(format, args));
            }
        }
    }
}

