/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.log;

import com.jfinal.log.ILogFactory;
import com.jfinal.log.Log;
import com.jfinal.log.Slf4jLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLogFactory
implements ILogFactory {
    @Override
    public Log getLog(Class<?> clazz) {
        Logger log = LoggerFactory.getLogger(clazz);
        return log instanceof LocationAwareLogger ? new Slf4jLog((LocationAwareLogger)log) : new Slf4jSimpleLog(log);
    }

    @Override
    public Log getLog(String name) {
        Logger log = LoggerFactory.getLogger((String)name);
        return log instanceof LocationAwareLogger ? new Slf4jLog((LocationAwareLogger)log) : new Slf4jSimpleLog(log);
    }

    public static class Slf4jSimpleLog
    extends Log {
        private Logger log;

        Slf4jSimpleLog(Logger log) {
            this.log = log;
        }

        @Override
        public void debug(String message) {
            this.log.debug(message);
        }

        @Override
        public void debug(String message, Throwable t) {
            this.log.debug(message, t);
        }

        @Override
        public void info(String message) {
            this.log.info(message);
        }

        @Override
        public void info(String message, Throwable t) {
            this.log.info(message, t);
        }

        @Override
        public void warn(String message) {
            this.log.warn(message);
        }

        @Override
        public void warn(String message, Throwable t) {
            this.log.warn(message, t);
        }

        @Override
        public void error(String message) {
            this.log.error(message);
        }

        @Override
        public void error(String message, Throwable t) {
            this.log.error(message, t);
        }

        @Override
        public void fatal(String message) {
            this.log.error(message);
        }

        @Override
        public void fatal(String message, Throwable t) {
            this.log.error(message, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.log.isInfoEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.log.isWarnEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.log.isErrorEnabled();
        }

        @Override
        public boolean isFatalEnabled() {
            return this.log.isErrorEnabled();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.log.isTraceEnabled();
        }

        @Override
        public void trace(String message) {
            this.log.trace(message);
        }

        @Override
        public void trace(String message, Throwable t) {
            this.log.trace(message, t);
        }

        @Override
        public void trace(String format, Object ... args) {
            if (this.isTraceEnabled()) {
                this.log.trace(format, args);
            }
        }

        @Override
        public void debug(String format, Object ... args) {
            if (this.isDebugEnabled()) {
                this.log.debug(format, args);
            }
        }

        @Override
        public void info(String format, Object ... args) {
            if (this.isInfoEnabled()) {
                this.log.info(format, args);
            }
        }

        @Override
        public void warn(String format, Object ... args) {
            if (this.isWarnEnabled()) {
                this.log.warn(format, args);
            }
        }

        @Override
        public void error(String format, Object ... args) {
            if (this.isErrorEnabled()) {
                this.log.error(format, args);
            }
        }

        @Override
        public void fatal(String format, Object ... args) {
            if (this.isFatalEnabled()) {
                this.log.error(format, args);
            }
        }
    }
}

