/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.dialect;

import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.ModelBuilder;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.RecordBuilder;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.builder.KeepByteAndShortModelBuilder;
import com.jfinal.plugin.activerecord.builder.KeepByteAndShortRecordBuilder;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class Dialect {
    protected boolean keepByteAndShort = false;
    protected ModelBuilder modelBuilder = ModelBuilder.me;
    protected RecordBuilder recordBuilder = RecordBuilder.me;

    public abstract String forTableBuilderDoBuild(String var1);

    public abstract String forPaginate(int var1, int var2, StringBuilder var3);

    public abstract String forModelFindById(Table var1, String var2);

    public abstract String forModelDeleteById(Table var1);

    public abstract void forModelSave(Table var1, Map<String, Object> var2, StringBuilder var3, List<Object> var4);

    public abstract void forModelUpdate(Table var1, Map<String, Object> var2, Set<String> var3, StringBuilder var4, List<Object> var5);

    public abstract String forDbFindById(String var1, String[] var2);

    public abstract String forDbDeleteById(String var1, String[] var2);

    public abstract void forDbSave(String var1, String[] var2, Record var3, StringBuilder var4, List<Object> var5);

    public abstract void forDbUpdate(String var1, String[] var2, Object[] var3, Record var4, StringBuilder var5, List<Object> var6);

    public String forFindAll(String tableName) {
        return "select * from " + tableName;
    }

    public Dialect setKeepByteAndShort(boolean keepByteAndShort) {
        this.keepByteAndShort = keepByteAndShort;
        if (keepByteAndShort) {
            if (this.modelBuilder.getClass() == ModelBuilder.class) {
                this.modelBuilder = KeepByteAndShortModelBuilder.me;
            }
            if (this.recordBuilder.getClass() == RecordBuilder.class) {
                this.recordBuilder = KeepByteAndShortRecordBuilder.me;
            }
        } else {
            if (this.modelBuilder.getClass() == KeepByteAndShortModelBuilder.class) {
                this.modelBuilder = ModelBuilder.me;
            }
            if (this.recordBuilder.getClass() == KeepByteAndShortRecordBuilder.class) {
                this.recordBuilder = RecordBuilder.me;
            }
        }
        return this;
    }

    public boolean isKeepByteAndShort() {
        return this.keepByteAndShort;
    }

    public Dialect setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder = modelBuilder;
        return this;
    }

    public Dialect setRecordBuilder(RecordBuilder recordBuilder) {
        this.recordBuilder = recordBuilder;
        return this;
    }

    public <T> List<T> buildModelList(ResultSet rs, Class<? extends Model> modelClass) throws SQLException, ReflectiveOperationException {
        return this.modelBuilder.build(rs, modelClass);
    }

    public List<Record> buildRecordList(Config config, ResultSet rs) throws SQLException {
        return this.recordBuilder.build(config, rs);
    }

    public void getModelGeneratedKey(Model<?> model, PreparedStatement pst, Table table) throws SQLException {
        String[] pKeys = table.getPrimaryKey();
        ResultSet rs = pst.getGeneratedKeys();
        for (String pKey : pKeys) {
            Class<?> colType;
            if (model.get(pKey) != null && !this.isOracle() || !rs.next() || (colType = table.getColumnType(pKey)) == null) continue;
            if (colType == Integer.class || colType == Integer.TYPE) {
                model.set(pKey, rs.getInt(1));
                continue;
            }
            if (colType == Long.class || colType == Long.TYPE) {
                model.set(pKey, rs.getLong(1));
                continue;
            }
            if (colType == BigInteger.class) {
                this.processGeneratedBigIntegerKey(model, pKey, rs.getObject(1));
                continue;
            }
            model.set(pKey, rs.getObject(1));
        }
        rs.close();
    }

    protected void processGeneratedBigIntegerKey(Model<?> model, String pKey, Object v) {
        if (v instanceof BigInteger) {
            model.set(pKey, (BigInteger)v);
        } else if (v instanceof Number) {
            Number n = (Number)v;
            model.set(pKey, BigInteger.valueOf(n.longValue()));
        } else {
            model.set(pKey, v);
        }
    }

    public void getRecordGeneratedKey(PreparedStatement pst, Record record, String[] pKeys) throws SQLException {
        ResultSet rs = pst.getGeneratedKeys();
        for (String pKey : pKeys) {
            if (record.get(pKey) != null && !this.isOracle() || !rs.next()) continue;
            record.set(pKey, rs.getObject(1));
        }
        rs.close();
    }

    public boolean isOracle() {
        return false;
    }

    public boolean isTakeOverDbPaginate() {
        return false;
    }

    public Page<Record> takeOverDbPaginate(Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws SQLException {
        throw new RuntimeException("You should implements this method in " + this.getClass().getName());
    }

    public boolean isTakeOverModelPaginate() {
        return false;
    }

    public Page takeOverModelPaginate(Connection conn, Class<? extends Model> modelClass, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws Exception {
        throw new RuntimeException("You should implements this method in " + this.getClass().getName());
    }

    public void fillStatement(PreparedStatement pst, List<Object> paras) throws SQLException {
        int size = paras.size();
        for (int i = 0; i < size; ++i) {
            pst.setObject(i + 1, paras.get(i));
        }
    }

    public void fillStatement(PreparedStatement pst, Object ... paras) throws SQLException {
        for (int i = 0; i < paras.length; ++i) {
            pst.setObject(i + 1, paras[i]);
        }
    }

    public String getDefaultPrimaryKey() {
        return "id";
    }

    public boolean isPrimaryKey(String colName, String[] pKeys) {
        for (String pKey : pKeys) {
            if (!colName.equalsIgnoreCase(pKey)) continue;
            return true;
        }
        return false;
    }

    public void trimPrimaryKeys(String[] pKeys) {
        for (int i = 0; i < pKeys.length; ++i) {
            pKeys[i] = pKeys[i].trim();
        }
    }

    public String replaceOrderBy(String sql) {
        return Holder.ORDER_BY_PATTERN.matcher(sql).replaceAll("");
    }

    protected void fillStatementHandleDateType(PreparedStatement pst, List<Object> paras) throws SQLException {
        int size = paras.size();
        for (int i = 0; i < size; ++i) {
            Object value = paras.get(i);
            if (value instanceof java.util.Date) {
                if (value instanceof Date) {
                    pst.setDate(i + 1, (Date)value);
                    continue;
                }
                if (value instanceof Timestamp) {
                    pst.setTimestamp(i + 1, (Timestamp)value);
                    continue;
                }
                java.util.Date d = (java.util.Date)value;
                pst.setTimestamp(i + 1, new Timestamp(d.getTime()));
                continue;
            }
            pst.setObject(i + 1, value);
        }
    }

    protected void fillStatementHandleDateType(PreparedStatement pst, Object ... paras) throws SQLException {
        for (int i = 0; i < paras.length; ++i) {
            Object value = paras[i];
            if (value instanceof java.util.Date) {
                if (value instanceof Date) {
                    pst.setDate(i + 1, (Date)value);
                    continue;
                }
                if (value instanceof Timestamp) {
                    pst.setTimestamp(i + 1, (Timestamp)value);
                    continue;
                }
                java.util.Date d = (java.util.Date)value;
                pst.setTimestamp(i + 1, new Timestamp(d.getTime()));
                continue;
            }
            pst.setObject(i + 1, value);
        }
    }

    protected static class Holder {
        private static final Pattern ORDER_BY_PATTERN = Pattern.compile("order\\s+by\\s+[^,\\s]+(\\s+asc|\\s+desc)?(\\s*,\\s*[^,\\s]+(\\s+asc|\\s+desc)?)*", 10);

        protected Holder() {
        }
    }
}

