/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.druid;

import com.alibaba.druid.support.http.StatViewServlet;
import com.jfinal.handler.Handler;
import com.jfinal.kit.HandlerKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.druid.IDruidStatViewAuth;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DruidStatViewHandler
extends Handler {
    private IDruidStatViewAuth auth;
    private String visitPath = "/druid";
    private StatViewServlet servlet = new JFinalStatViewServlet();

    public DruidStatViewHandler(String visitPath) {
        this(visitPath, new IDruidStatViewAuth(){

            @Override
            public boolean isPermitted(HttpServletRequest request) {
                return true;
            }
        });
    }

    public DruidStatViewHandler(String visitPath, IDruidStatViewAuth druidStatViewAuth) {
        if (StrKit.isBlank(visitPath)) {
            throw new IllegalArgumentException("visitPath can not be blank");
        }
        if (druidStatViewAuth == null) {
            throw new IllegalArgumentException("druidStatViewAuth can not be null");
        }
        if (!(visitPath = visitPath.trim()).startsWith("/")) {
            visitPath = "/" + visitPath;
        }
        this.visitPath = visitPath;
        this.auth = druidStatViewAuth;
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.startsWith(this.visitPath)) {
            isHandled[0] = true;
            String ctx = request.getContextPath();
            if (ctx != null && !"".equals(ctx) && !"/".equals(ctx)) {
                target = ctx + target;
            }
            if (target.equals(this.visitPath) && !target.endsWith("/index.html")) {
                target = target + "/index.html";
                HandlerKit.redirect(target, request, response, isHandled);
                return;
            }
            try {
                this.servlet.service(request, response);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.next.handle(target, request, response, isHandled);
        }
    }

    class JFinalStatViewServlet
    extends StatViewServlet {
        private static final long serialVersionUID = 2898674199964021798L;

        JFinalStatViewServlet() {
        }

        public boolean isPermittedRequest(HttpServletRequest request) {
            return DruidStatViewHandler.this.auth.isPermitted(request);
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String contextPath = request.getContextPath();
            String requestURI = request.getRequestURI();
            response.setCharacterEncoding("utf-8");
            if (contextPath == null) {
                contextPath = "";
            }
            int index = contextPath.length() + DruidStatViewHandler.this.visitPath.length();
            String uri = requestURI.substring(0, index);
            String path = requestURI.substring(index);
            if (!this.isPermittedRequest(request)) {
                path = "/nopermit.html";
                this.returnResourceFile(path, uri, response);
                return;
            }
            if ("/submitLogin".equals(path)) {
                String usernameParam = request.getParameter("loginUsername");
                String passwordParam = request.getParameter("loginPassword");
                if (this.username.equals(usernameParam) && this.password.equals(passwordParam)) {
                    request.getSession().setAttribute("druid-user", (Object)this.username);
                    response.getWriter().print("success");
                } else {
                    response.getWriter().print("error");
                }
                return;
            }
            if (!(!this.isRequireAuth() || this.ContainsUser(request) || "/login.html".equals(path) || path.startsWith("/css") || path.startsWith("/js") || path.startsWith("/img"))) {
                if (contextPath == null || contextPath.equals("") || contextPath.equals("/")) {
                    response.sendRedirect("/druid/login.html");
                } else if ("".equals(path)) {
                    response.sendRedirect("druid/login.html");
                } else {
                    response.sendRedirect("login.html");
                }
                return;
            }
            if ("".equals(path)) {
                if (contextPath == null || contextPath.equals("") || contextPath.equals("/")) {
                    response.sendRedirect("/druid/index.html");
                } else {
                    response.sendRedirect("druid/index.html");
                }
                return;
            }
            if ("/".equals(path)) {
                response.sendRedirect("index.html");
                return;
            }
            if (path.indexOf(".json") >= 0) {
                String fullUrl = path;
                if (request.getQueryString() != null && request.getQueryString().length() > 0) {
                    fullUrl = fullUrl + "?" + request.getQueryString();
                }
                response.getWriter().print(this.process(fullUrl));
                return;
            }
            this.returnResourceFile(path, uri, response);
        }
    }
}

