/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.ehcache;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.plugin.ehcache.CacheKit;
import com.jfinal.plugin.ehcache.CacheName;

public class EvictInterceptor
implements Interceptor {
    @Override
    public void intercept(Invocation inv) {
        inv.invoke();
        String[] cacheNames = this.getCacheName(inv).split(",");
        if (cacheNames.length == 1) {
            CacheKit.removeAll(cacheNames[0].trim());
        } else {
            for (String cn : cacheNames) {
                CacheKit.removeAll(cn.trim());
            }
        }
    }

    protected String getCacheName(Invocation inv) {
        CacheName cacheName = inv.getMethod().getAnnotation(CacheName.class);
        if (cacheName != null) {
            return cacheName.value();
        }
        cacheName = inv.getController().getClass().getAnnotation(CacheName.class);
        if (cacheName == null) {
            throw new RuntimeException("EvictInterceptor need CacheName annotation in controller.");
        }
        return cacheName.value();
    }
}

