/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import java.util.HashMap;
import java.util.Map;

public enum ContentType {
    TEXT("text/plain"),
    HTML("text/html"),
    XML("text/xml"),
    JSON("application/json"),
    JAVASCRIPT("application/javascript");

    private final String value;
    private static final Map<String, ContentType> mapping;

    private ContentType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    private static Map<String, ContentType> initMapping() {
        HashMap<String, ContentType> ret = new HashMap<String, ContentType>();
        ret.put("text", TEXT);
        ret.put("plain", TEXT);
        ret.put("html", HTML);
        ret.put("xml", XML);
        ret.put("json", JSON);
        ret.put("javascript", JAVASCRIPT);
        ret.put("js", JAVASCRIPT);
        ret.put("TEXT", TEXT);
        ret.put("PLAIN", TEXT);
        ret.put("HTML", HTML);
        ret.put("XML", XML);
        ret.put("JSON", JSON);
        ret.put("JAVASCRIPT", JAVASCRIPT);
        ret.put("JS", JAVASCRIPT);
        return ret;
    }

    public static ContentType parse(String str) {
        return mapping.get(str);
    }

    static {
        mapping = ContentType.initMapping();
    }
}

