/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import java.io.IOException;

public class ErrorRender
extends Render {
    protected static final String contentType = "text/html; charset=" + ErrorRender.getEncoding();
    protected static final String version = "<center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 4.9</b></a></center>";
    protected static final byte[] html404 = "<html><head><title>404 Not Found</title></head><body bgcolor='white'><center><h1>404 Not Found</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 4.9</b></a></center></body></html>".getBytes();
    protected static final byte[] html500 = "<html><head><title>500 Internal Server Error</title></head><body bgcolor='white'><center><h1>500 Internal Server Error</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 4.9</b></a></center></body></html>".getBytes();
    protected static final byte[] html400 = "<html><head><title>400 Bad Request</title></head><body bgcolor='white'><center><h1>400 Bad Request</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 4.9</b></a></center></body></html>".getBytes();
    protected static final byte[] html401 = "<html><head><title>401 Unauthorized</title></head><body bgcolor='white'><center><h1>401 Unauthorized</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 4.9</b></a></center></body></html>".getBytes();
    protected static final byte[] html403 = "<html><head><title>403 Forbidden</title></head><body bgcolor='white'><center><h1>403 Forbidden</h1></center><hr><center><a href='https://gitee.com/jfinal/jfinal' target='_blank'><b>Powered by JFinal 4.9</b></a></center></body></html>".getBytes();
    protected int errorCode;

    public ErrorRender(int errorCode, String view) {
        this.errorCode = errorCode;
        this.view = view;
    }

    @Override
    public void render() {
        this.response.setStatus(this.getErrorCode());
        String view = this.getView();
        if (view != null) {
            RenderManager.me().getRenderFactory().getRender(view).setContext(this.request, this.response).render();
            return;
        }
        try {
            this.response.setContentType(contentType);
            this.response.getOutputStream().write(this.getErrorHtml());
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    public byte[] getErrorHtml() {
        int errorCode = this.getErrorCode();
        if (errorCode == 404) {
            return html404;
        }
        if (errorCode == 500) {
            return html500;
        }
        if (errorCode == 400) {
            return html400;
        }
        if (errorCode == 401) {
            return html401;
        }
        if (errorCode == 403) {
            return html403;
        }
        return ("<html><head><title>" + errorCode + " Error</title></head><body bgcolor='white'><center><h1>" + errorCode + " Error</h1></center><hr>" + version + "</body></html>").getBytes();
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

