/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.core.JFinal;
import com.jfinal.kit.HttpKit;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;

public class RedirectRender
extends Render {
    protected String url;
    protected boolean withQueryString;
    protected static final String contextPath = RedirectRender.getContxtPath();

    static String getContxtPath() {
        String cp = JFinal.me().getContextPath();
        return "".equals(cp) || "/".equals(cp) ? null : cp;
    }

    public RedirectRender(String url) {
        this.url = url;
        this.withQueryString = false;
    }

    public RedirectRender(String url, boolean withQueryString) {
        this.url = url;
        this.withQueryString = withQueryString;
    }

    public String buildFinalUrl() {
        String queryString;
        String ret = contextPath != null && (this.url.indexOf("://") == -1 || this.url.indexOf("://") > 5) ? contextPath + this.url : this.url;
        if (this.withQueryString && (queryString = this.request.getQueryString()) != null) {
            ret = ret.indexOf(63) == -1 ? ret + "?" + queryString : ret + "&" + queryString;
        }
        if (ret.toLowerCase().startsWith("http")) {
            return ret;
        }
        if (!HttpKit.isHttps(this.request)) {
            return ret;
        }
        String serverName = this.request.getServerName();
        int port = this.request.getServerPort();
        if (port != 443) {
            serverName = serverName + ":" + port;
        }
        if (ret.charAt(0) != '/') {
            return "https://" + serverName + "/" + ret;
        }
        return "https://" + serverName + ret;
    }

    @Override
    public void render() {
        String finalUrl = this.buildFinalUrl();
        try {
            this.response.sendRedirect(finalUrl);
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }
}

