/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.Sym;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Objects;

public class Arith
extends Expr {
    public static final int INT = 0;
    public static final int LONG = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int BIGINTEGER = 4;
    public static final int BIGDECIMAL = 5;
    public static final int UNKNOWN = 99;
    private Sym op;
    private Expr left;
    private Expr right;
    protected static int bigDecimalDivideMinScale = 5;
    protected static RoundingMode bigDecimalDivideRoundingMode = RoundingMode.HALF_UP;

    public static void setBigDecimalDivideMinScale(int scale) {
        bigDecimalDivideMinScale = scale;
    }

    public static void setBigDecimalDivideRoundingMode(RoundingMode roundingMode) {
        Objects.requireNonNull(roundingMode, "roundingMode can not be null");
        bigDecimalDivideRoundingMode = roundingMode;
    }

    public Arith(Sym op, Expr left, Expr right, Location location) {
        if (left == null || right == null) {
            throw new ParseException("The target of \"" + op.value() + "\" operator can not be blank", location);
        }
        this.op = op;
        this.left = left;
        this.right = right;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        try {
            return this.doEval(scope);
        }
        catch (TemplateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }

    private Object doEval(Scope scope) {
        Object leftValue = this.left.eval(scope);
        Object rightValue = this.right.eval(scope);
        if (leftValue instanceof Number && rightValue instanceof Number) {
            Number l = (Number)leftValue;
            Number r = (Number)rightValue;
            int maxType = Arith.getMaxType(l, r);
            if (maxType == 99) {
                throw Arith.unsupportedTypeException(l, r, this.location);
            }
            switch (this.op) {
                case ADD: {
                    return this.add(maxType, l, r);
                }
                case SUB: {
                    return this.sub(maxType, l, r);
                }
                case MUL: {
                    return this.mul(maxType, l, r);
                }
                case DIV: {
                    return this.div(maxType, l, r);
                }
                case MOD: {
                    return this.remainder(maxType, l, r);
                }
            }
            throw new TemplateException("Unsupported operator: " + this.op.value(), this.location);
        }
        if (this.op == Sym.ADD && (leftValue instanceof String || rightValue instanceof String)) {
            return String.valueOf(leftValue).concat(String.valueOf(rightValue));
        }
        String leftObj = leftValue != null ? leftValue.getClass().getName() : "null";
        String rightObj = rightValue != null ? rightValue.getClass().getName() : "null";
        throw new TemplateException("Unsupported operation type: " + leftObj + " " + this.op.value() + " " + rightObj, this.location);
    }

    static BigDecimal[] toBigDecimals(Number left, Number right) {
        BigDecimal[] ret = new BigDecimal[]{left instanceof BigDecimal ? (BigDecimal)left : new BigDecimal(left.toString()), right instanceof BigDecimal ? (BigDecimal)right : new BigDecimal(right.toString())};
        return ret;
    }

    static BigInteger[] toBigIntegers(Number left, Number right) {
        BigInteger[] ret = new BigInteger[]{left instanceof BigInteger ? (BigInteger)left : new BigInteger(left.toString()), right instanceof BigInteger ? (BigInteger)right : new BigInteger(right.toString())};
        return ret;
    }

    static int getMaxType(Number obj1, Number obj2) {
        int t2;
        int ret;
        int t1 = Arith.getType(obj1);
        int n = ret = t1 > (t2 = Arith.getType(obj2)) ? t1 : t2;
        if (ret != 4) {
            return ret;
        }
        if (t1 == 4 ? t2 == 3 || t2 == 2 : t1 == 3 || t1 == 2) {
            return 5;
        }
        return ret;
    }

    static int getType(Number obj) {
        if (obj instanceof Integer) {
            return 0;
        }
        if (obj instanceof Long) {
            return 1;
        }
        if (obj instanceof Float) {
            return 2;
        }
        if (obj instanceof Double) {
            return 3;
        }
        if (obj instanceof BigDecimal) {
            return 5;
        }
        if (obj instanceof Short || obj instanceof Byte) {
            return 0;
        }
        if (obj instanceof BigInteger) {
            return 4;
        }
        return 99;
    }

    private Number add(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() + right.intValue();
            }
            case 1: {
                return left.longValue() + right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() + right.floatValue());
            }
            case 3: {
                return left.doubleValue() + right.doubleValue();
            }
            case 5: {
                BigDecimal[] bd = Arith.toBigDecimals(left, right);
                return bd[0].add(bd[1]);
            }
            case 4: {
                BigInteger[] bi = Arith.toBigIntegers(left, right);
                return bi[0].add(bi[1]);
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }

    private Number sub(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() - right.intValue();
            }
            case 1: {
                return left.longValue() - right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() - right.floatValue());
            }
            case 3: {
                return left.doubleValue() - right.doubleValue();
            }
            case 5: {
                BigDecimal[] bd = Arith.toBigDecimals(left, right);
                return bd[0].subtract(bd[1]);
            }
            case 4: {
                BigInteger[] bi = Arith.toBigIntegers(left, right);
                return bi[0].subtract(bi[1]);
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }

    private Number mul(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() * right.intValue();
            }
            case 1: {
                return left.longValue() * right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() * right.floatValue());
            }
            case 3: {
                return left.doubleValue() * right.doubleValue();
            }
            case 5: {
                BigDecimal[] bd = Arith.toBigDecimals(left, right);
                return bd[0].multiply(bd[1]);
            }
            case 4: {
                BigInteger[] bi = Arith.toBigIntegers(left, right);
                return bi[0].multiply(bi[1]);
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }

    private Number div(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() / right.intValue();
            }
            case 1: {
                return left.longValue() / right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() / right.floatValue());
            }
            case 3: {
                return left.doubleValue() / right.doubleValue();
            }
            case 5: {
                BigDecimal[] bd = Arith.toBigDecimals(left, right);
                int scale = Math.max(bigDecimalDivideMinScale, bd[0].scale());
                return bd[0].divide(bd[1], scale, bigDecimalDivideRoundingMode);
            }
            case 4: {
                BigInteger[] bi = Arith.toBigIntegers(left, right);
                return bi[0].divide(bi[1]);
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }

    private Number remainder(int maxType, Number left, Number right) {
        switch (maxType) {
            case 0: {
                return left.intValue() % right.intValue();
            }
            case 1: {
                return left.longValue() % right.longValue();
            }
            case 2: {
                return Float.valueOf(left.floatValue() % right.floatValue());
            }
            case 3: {
                return left.doubleValue() % right.doubleValue();
            }
            case 5: {
                BigDecimal[] bd = Arith.toBigDecimals(left, right);
                return bd[0].divideAndRemainder(bd[1])[1];
            }
            case 4: {
                BigInteger[] bi = Arith.toBigIntegers(left, right);
                return bi[0].divideAndRemainder(bi[1])[1];
            }
        }
        throw new TemplateException("Unsupported data type", this.location);
    }

    static TemplateException unsupportedTypeException(Number left, Number right, Location location) {
        Number unsupportedType = left instanceof Integer || left instanceof Long || left instanceof Float || left instanceof Double || left instanceof BigDecimal || left instanceof Short || left instanceof Byte || left instanceof BigInteger ? (Number)right : (Number)left;
        return new TemplateException("Unsupported data type: " + unsupportedType.getClass().getName(), location);
    }
}

