/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.Logic;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;

public class Ternary
extends Expr {
    private Expr cond;
    private Expr exprOne;
    private Expr exprTwo;

    public Ternary(Expr cond, Expr exprOne, Expr exprTwo, Location location) {
        if (cond == null || exprOne == null || exprTwo == null) {
            throw new ParseException("The parameter of ternary expression can not be blank", location);
        }
        this.cond = cond;
        this.exprOne = exprOne;
        this.exprTwo = exprTwo;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        return Logic.isTrue(this.cond.eval(scope)) ? this.exprOne.eval(scope) : this.exprTwo.eval(scope);
    }
}

