/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.io;

import java.io.IOException;
import java.io.Writer;

public class FastStringWriter
extends Writer {
    private char[] value;
    private int len;
    private static int MAX_BUFFER_SIZE = 524288;

    public static void setMaxBufferSize(int maxBufferSize) {
        int min = 256;
        if (maxBufferSize < min) {
            throw new IllegalArgumentException("maxBufferSize must more than " + min);
        }
        MAX_BUFFER_SIZE = maxBufferSize;
    }

    @Override
    public void close() {
        this.len = 0;
        if (this.value.length > MAX_BUFFER_SIZE) {
            this.value = new char[Math.max(256, MAX_BUFFER_SIZE / 2)];
        }
    }

    public String toString() {
        return new String(this.value, 0, this.len);
    }

    public StringBuilder toStringBuilder() {
        return new StringBuilder(this.len + 64).append(this.value, 0, this.len);
    }

    public FastStringWriter(int capacity) {
        this.value = new char[capacity];
    }

    public FastStringWriter() {
        this(128);
    }

    protected void expandCapacity(int newLen) {
        int newCapacity = Math.max(newLen, this.value.length * 2);
        char[] newValue = new char[newCapacity];
        if (this.len > 0) {
            System.arraycopy(this.value, 0, newValue, 0, this.len);
        }
        this.value = newValue;
    }

    @Override
    public void write(char[] buffer, int offset, int len) throws IOException {
        int newLen = this.len + len;
        if (newLen > this.value.length) {
            this.expandCapacity(newLen);
        }
        System.arraycopy(buffer, offset, this.value, this.len, len);
        this.len = newLen;
    }

    @Override
    public void write(String str, int offset, int len) throws IOException {
        int newLen = this.len + len;
        if (newLen > this.value.length) {
            this.expandCapacity(newLen);
        }
        str.getChars(offset, offset + len, this.value, this.len);
        this.len = newLen;
    }

    @Override
    public void write(int c) throws IOException {
        char[] buffer = new char[]{(char)c};
        this.write(buffer, 0, 1);
    }

    @Override
    public void write(char[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        if (csq instanceof String) {
            String str = (String)csq;
            this.write(str, 0, str.length());
            return this;
        }
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (csq instanceof String) {
            String str = (String)csq;
            this.write(str, start, end - start);
            return this;
        }
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        char[] buffer = new char[]{c};
        this.write(buffer, 0, 1);
        return this;
    }

    @Override
    public void flush() throws IOException {
    }
}

