/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop;

import com.jfinal.aop.AopFactory;
import com.jfinal.aop.Inject;
import com.jfinal.core.Controller;
import com.jfinal.ext.proxy.CglibProxyFactory;
import com.jfinal.kit.LogKit;
import com.jfinal.log.Log;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.proxy.Proxy;
import com.jfinal.proxy.ProxyFactory;
import com.jfinal.proxy.ProxyManager;
import io.jboot.Jboot;
import io.jboot.aop.annotation.Bean;
import io.jboot.aop.annotation.BeanExclude;
import io.jboot.aop.annotation.ConfigValue;
import io.jboot.aop.annotation.Configuration;
import io.jboot.aop.annotation.StaticConstruct;
import io.jboot.app.config.ConfigUtil;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.config.annotation.ConfigModel;
import io.jboot.components.event.JbootEventListener;
import io.jboot.components.mq.JbootmqMessageListener;
import io.jboot.components.rpc.Jbootrpc;
import io.jboot.components.rpc.JbootrpcManager;
import io.jboot.components.rpc.JbootrpcReferenceConfig;
import io.jboot.components.rpc.annotation.RPCInject;
import io.jboot.db.model.JbootModel;
import io.jboot.exception.JbootException;
import io.jboot.service.JbootServiceBase;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassScanner;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import io.jboot.web.controller.JbootController;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JbootAopFactory
extends AopFactory {
    private static final Log LOG = Log.getLog(JbootAopFactory.class);
    private static final Class[] DEFAULT_EXCLUDES_MAPPING_CLASSES = new Class[]{JbootEventListener.class, JbootmqMessageListener.class, Serializable.class};
    private static JbootAopFactory me = new JbootAopFactory();
    private Map<String, Object> beansMap = new ConcurrentHashMap<String, Object>();

    public static JbootAopFactory me() {
        return me;
    }

    private JbootAopFactory() {
        ProxyManager.me().setProxyFactory((ProxyFactory)new CglibProxyFactory());
        this.setInjectSuperClass(true);
        this.initBeanMapping();
    }

    protected Object createObject(Class<?> targetClass) {
        ConfigModel configModel = targetClass.getAnnotation(ConfigModel.class);
        if (configModel != null) {
            return JbootConfigManager.me().get(targetClass);
        }
        StaticConstruct staticConstruct = targetClass.getAnnotation(StaticConstruct.class);
        if (staticConstruct != null) {
            return ClassUtil.newInstanceByStaticConstruct(targetClass, staticConstruct);
        }
        return Proxy.get(targetClass);
    }

    protected void doInject(Class<?> targetClass, Object targetObject) throws ReflectiveOperationException {
        Class c;
        Field[] fields = (targetClass = this.getUsefulClass(targetClass)).getDeclaredFields();
        if (fields.length != 0) {
            for (Field field : fields) {
                Inject inject = field.getAnnotation(Inject.class);
                if (inject != null) {
                    String beanName;
                    Bean bean = field.getAnnotation(Bean.class);
                    String string = beanName = bean != null ? AnnotationUtil.get(bean.name()) : null;
                    if (StrUtil.isNotBlank(beanName)) {
                        this.doInjectByName(targetObject, field, inject, beanName);
                        continue;
                    }
                    this.doInjectJFinalOrginal(targetObject, field, inject);
                    continue;
                }
                ConfigValue configValue = field.getAnnotation(ConfigValue.class);
                if (configValue != null) {
                    this.doInjectConfigValue(targetObject, field, configValue);
                    continue;
                }
                RPCInject rpcInject = field.getAnnotation(RPCInject.class);
                if (rpcInject == null) continue;
                this.doInjectRPC(targetObject, field, rpcInject);
            }
        }
        if (this.injectSuperClass && (c = targetClass.getSuperclass()) != JbootController.class && c != Controller.class && c != JbootServiceBase.class && c != Object.class && c != JbootModel.class && c != Model.class && c != null) {
            this.doInject(c, targetObject);
        }
    }

    private void doInjectByName(Object targetObject, Field field, Inject inject, String name) throws ReflectiveOperationException {
        Object fieldInjectedObject = this.getBean(name);
        if (fieldInjectedObject != null) {
            this.setFieldValue(field, targetObject, fieldInjectedObject);
        } else {
            LOG.warn("can not inject by name [" + name + "] in " + targetObject.getClass() + "." + field.getName() + ", use default.");
            this.doInjectJFinalOrginal(targetObject, field, inject);
        }
    }

    private void doInjectJFinalOrginal(Object targetObject, Field field, Inject inject) throws ReflectiveOperationException {
        Class<?> fieldInjectedClass = inject.value();
        if (fieldInjectedClass == Void.class) {
            fieldInjectedClass = field.getType();
        }
        Object fieldInjectedObject = this.doGet(fieldInjectedClass);
        this.setFieldValue(field, targetObject, fieldInjectedObject);
    }

    private void doInjectRPC(Object targetObject, Field field, RPCInject rpcInject) {
        try {
            JbootrpcReferenceConfig serviceConfig = new JbootrpcReferenceConfig(rpcInject);
            Class<?> fieldInjectedClass = field.getType();
            Jbootrpc jbootrpc = JbootrpcManager.me().getJbootrpc();
            Object fieldInjectedObject = jbootrpc.serviceObtain(fieldInjectedClass, serviceConfig);
            this.setFieldValue(field, targetObject, fieldInjectedObject);
        }
        catch (Exception ex) {
            LOG.error("can not inject rpc service in " + targetObject.getClass() + " by config " + rpcInject, (Throwable)ex);
        }
    }

    private void doInjectConfigValue(Object targetObject, Field field, ConfigValue configValue) throws IllegalAccessException {
        Object fieldInjectedObject;
        String key = AnnotationUtil.get(configValue.value());
        Class<?> fieldInjectedClass = field.getType();
        String value = this.getConfigValue(key, targetObject, field);
        if (StrUtil.isNotBlank(value) && (fieldInjectedObject = ConfigUtil.convert(fieldInjectedClass, value, field.getGenericType())) != null) {
            this.setFieldValue(field, targetObject, fieldInjectedObject);
        }
    }

    private String getConfigValue(String key, Object targetObject, Field field) {
        return Jboot.configValue(key);
    }

    public synchronized <T> AopFactory addMapping(Class<T> from, Class<? extends T> to) {
        Class mappingClass;
        if (from == null || to == null) {
            throw new IllegalArgumentException("The parameter from and to can not be null");
        }
        if (this.mapping == null) {
            this.mapping = new HashMap(128, 0.25f);
        }
        if ((mappingClass = (Class)this.mapping.get(from)) != null) {
            if (mappingClass == to) {
                return this;
            }
            this.singletonCache.remove(mappingClass);
            LogKit.warn((String)("Aop Class[" + from + "] mapping changed from  " + mappingClass + " to " + to));
        }
        this.mapping.put(from, to);
        return this;
    }

    protected void setFieldValue(Field field, Object toObj, Object data) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(toObj, data);
    }

    private void initBeanMapping() {
        List<Class> classes = ClassScanner.scanClassByAnnotation(Bean.class, true);
        for (Class implClass : classes) {
            Class<?>[] interfaceClasses;
            Bean bean = implClass.getAnnotation(Bean.class);
            String beanName = AnnotationUtil.get(bean.name());
            if (StrUtil.isNotBlank(beanName)) {
                if (this.beansMap.containsKey(beanName)) {
                    throw new JbootException("application has contains beanName \"" + beanName + "\" for " + this.getBean(beanName) + ", can not add for class " + implClass);
                }
                this.beansMap.put(beanName, this.get(implClass));
            }
            if ((interfaceClasses = implClass.getInterfaces()) == null || interfaceClasses.length == 0) continue;
            Class[] excludes = this.buildExcludeClasses(implClass);
            Class<?>[] classArray = interfaceClasses;
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> interfaceClass = classArray[i];
                if (this.inExcludes(interfaceClass, excludes)) continue;
                this.addMapping(interfaceClass, implClass);
            }
        }
        List<Class> configurationClasses = ClassScanner.scanClassByAnnotation(Configuration.class, true);
        for (Class configurationClass : configurationClasses) {
            Method[] methods;
            Object configurationObj = ClassUtil.newInstance(configurationClass);
            if (configurationObj == null) {
                throw new NullPointerException("can not newInstance for class : " + configurationClass);
            }
            for (Method method : methods = configurationClass.getDeclaredMethods()) {
                Class implClass;
                Class<?>[] interfaceClasses;
                Bean bean = method.getAnnotation(Bean.class);
                if (bean == null) continue;
                String beanName = StrUtil.obtainDefaultIfBlank(AnnotationUtil.get(bean.name()), method.getName());
                if (this.beansMap.containsKey(beanName)) {
                    throw new JbootException("application has contains beanName \"" + beanName + "\" for " + this.getBean(beanName) + ", can not add again by method:" + ClassUtil.buildMethodString(method));
                }
                Object methodObj = null;
                try {
                    methodObj = method.invoke(configurationObj, new Object[0]);
                    if (methodObj != null) {
                        this.inject(methodObj);
                        this.beansMap.put(beanName, methodObj);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (methodObj == null || (interfaceClasses = (implClass = ClassUtil.getUsefulClass(methodObj.getClass())).getInterfaces()) == null || interfaceClasses.length == 0) continue;
                Class[] excludes = this.buildExcludeClasses(implClass);
                for (Class<?> interfaceClass : interfaceClasses) {
                    if (this.inExcludes(interfaceClass, excludes) || this.mapping.containsKey(interfaceClass)) continue;
                    this.addMapping(interfaceClass, implClass);
                }
            }
        }
    }

    private Class[] buildExcludeClasses(Class implClass) {
        BeanExclude beanExclude = implClass.getAnnotation(BeanExclude.class);
        return beanExclude == null ? DEFAULT_EXCLUDES_MAPPING_CLASSES : ArrayUtil.concat(DEFAULT_EXCLUDES_MAPPING_CLASSES, new Class[][]{beanExclude.value()});
    }

    private boolean inExcludes(Class interfaceClass, Class[] excludes) {
        for (Class ex : excludes) {
            if (!ex.isAssignableFrom(interfaceClass)) continue;
            return true;
        }
        return false;
    }

    public <T> T getBean(String name) {
        return (T)this.beansMap.get(name);
    }

    public void setBean(String name, Object obj) {
        this.beansMap.put(name, obj);
    }
}

