/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.aop;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.aop.JbootAopInvocation;
import io.jboot.components.cache.interceptor.JbootCacheEvictInterceptor;
import io.jboot.components.cache.interceptor.JbootCacheInterceptor;
import io.jboot.components.cache.interceptor.JbootCachePutInterceptor;
import io.jboot.components.cache.interceptor.JbootCachesEvictInterceptor;
import io.jboot.components.limiter.LimiterInterceptor;
import io.jboot.support.metric.JbootMetricInterceptor;
import io.jboot.support.seata.interceptor.SeataGlobalTransactionalInterceptor;
import io.jboot.support.sentinel.SentinelInterceptor;
import java.util.LinkedList;

public class JbootAopInterceptor
implements Interceptor {
    static final Interceptor[] JBOOT_INTERS = new Interceptor[]{new SentinelInterceptor(), new LimiterInterceptor(), new JbootMetricInterceptor(), new JbootCacheEvictInterceptor(), new JbootCachesEvictInterceptor(), new JbootCachePutInterceptor(), new JbootCacheInterceptor(), new SeataGlobalTransactionalInterceptor()};
    private static Interceptor[] aopInterceptors = JBOOT_INTERS;

    public void intercept(Invocation inv) {
        JbootAopInvocation invocation = new JbootAopInvocation(inv, aopInterceptors);
        invocation.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInterceptor(Interceptor interceptor, int toIndex) {
        if (interceptor == null) {
            throw new NullPointerException("interceptor is null");
        }
        Class<JbootAopInterceptor> clazz = JbootAopInterceptor.class;
        synchronized (JbootAopInterceptor.class) {
            int length = aopInterceptors.length;
            if (toIndex < 0) {
                toIndex = 0;
            }
            if (toIndex > length) {
                toIndex = length;
            }
            Interceptor[] temp = new Interceptor[length + 1];
            System.arraycopy(aopInterceptors, 0, temp, 0, toIndex);
            temp[toIndex] = interceptor;
            if (toIndex < length) {
                System.arraycopy(aopInterceptors, toIndex, temp, toIndex + 1, length - toIndex);
            }
            aopInterceptors = temp;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInterceptor(Interceptor interceptor) {
        if (interceptor == null) {
            throw new NullPointerException("interceptor is null");
        }
        Class<JbootAopInterceptor> clazz = JbootAopInterceptor.class;
        synchronized (JbootAopInterceptor.class) {
            int length = aopInterceptors.length;
            LinkedList<Interceptor> tempList = new LinkedList<Interceptor>();
            for (int i = 0; i < length; ++i) {
                if (aopInterceptors[i] == interceptor) continue;
                tempList.add(aopInterceptors[i]);
            }
            if (tempList.size() != length) {
                aopInterceptors = tempList.toArray(new Interceptor[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInterceptor(Class<? extends Interceptor> clazz) {
        if (clazz == null) {
            throw new NullPointerException("interceptor class is null");
        }
        Class<JbootAopInterceptor> clazz2 = JbootAopInterceptor.class;
        synchronized (JbootAopInterceptor.class) {
            int length = aopInterceptors.length;
            LinkedList<Interceptor> tempList = new LinkedList<Interceptor>();
            for (int i = 0; i < length; ++i) {
                if (aopInterceptors[i].getClass() == clazz) continue;
                tempList.add(aopInterceptors[i]);
            }
            if (tempList.size() != length) {
                aopInterceptors = tempList.toArray(new Interceptor[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

