/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import io.jboot.app.Banner;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.app.config.JbootConfigManager;
import java.net.URISyntaxException;
import java.net.URL;

class ApplicationUtil {
    ApplicationUtil() {
    }

    static JbootApplicationConfig getAppConfig(String[] args) {
        JbootConfigManager.me().parseArgs(args);
        return ApplicationUtil.getConfig(JbootApplicationConfig.class);
    }

    static void printBannerInfo(JbootApplicationConfig appConfig) {
        if (appConfig.isBannerEnable()) {
            System.out.println();
            System.out.println(Banner.getText(appConfig.getBannerFile()));
            System.out.println();
        }
    }

    static void printApplicationInfo(JbootApplicationConfig appConfig) {
        System.out.println(appConfig.toString());
    }

    static void printClassPath() {
        try {
            URL resourceURL = ApplicationUtil.class.getResource("/");
            if (resourceURL != null) {
                System.out.println("Classpath : " + resourceURL.toURI().getPath());
            } else {
                System.out.println("Classpath : application in one jar.");
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    static <T> T getConfig(Class<T> clazz) {
        return JbootConfigManager.me().get(clazz);
    }

    static String getConfigValue(String key) {
        return JbootConfigManager.me().getConfigValue(key);
    }

    static boolean isDevMode() {
        return JbootConfigManager.me().isDevMode();
    }
}

