/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import com.jfinal.server.undertow.UndertowConfig;
import com.jfinal.server.undertow.UndertowServer;
import com.jfinal.server.undertow.WebBuilder;
import io.jboot.app.ApplicationUtil;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.app.JbootResourceLoader;
import io.jboot.app.JbootWebBuilderConfiger;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.undertow.JbootUndertowConfig;
import io.jboot.app.undertow.JbootUndertowServer;
import javax.servlet.DispatcherType;

public class JbootApplication {
    public static void main(String[] args) {
        JbootApplication.run(args);
    }

    public static void run(String[] args) {
        JbootApplication.start(JbootApplication.createServer(args));
    }

    public static void run(String[] args, JbootWebBuilderConfiger configer) {
        JbootApplication.start(JbootApplication.createServer(args, configer));
    }

    public static void start(UndertowServer server) {
        server.start();
        if (ApplicationUtil.isDevMode()) {
            new JbootResourceLoader().start();
        }
    }

    public static void setBootArg(String key, Object value) {
        JbootConfigManager.me().setBootArg(key, value);
    }

    public static UndertowServer createServer(String[] args) {
        JbootApplicationConfig appConfig = ApplicationUtil.getAppConfig(args);
        return JbootApplication.createServer(appConfig, JbootApplication.createUndertowConfig(appConfig), null);
    }

    public static UndertowServer createServer(String[] args, JbootWebBuilderConfiger configer) {
        JbootApplicationConfig appConfig = ApplicationUtil.getAppConfig(args);
        return JbootApplication.createServer(appConfig, JbootApplication.createUndertowConfig(appConfig), configer);
    }

    public static UndertowServer createServer(JbootApplicationConfig appConfig, UndertowConfig undertowConfig, JbootWebBuilderConfiger configer) {
        ApplicationUtil.printBannerInfo(appConfig);
        ApplicationUtil.printApplicationInfo(appConfig);
        ApplicationUtil.printClassPath();
        return new JbootUndertowServer(undertowConfig).setDevMode(ApplicationUtil.isDevMode()).configWeb(webBuilder -> {
            JbootApplication.tryAddMetricsSupport(webBuilder);
            JbootApplication.tryAddShiroSupport(webBuilder);
            JbootApplication.tryAddWebSocketSupport(webBuilder);
            if (configer != null) {
                configer.onConfig((WebBuilder)webBuilder);
            }
        });
    }

    public static UndertowConfig createUndertowConfig(JbootApplicationConfig appConfig) {
        JbootUndertowConfig undertowConfig = new JbootUndertowConfig(appConfig.getJfinalConfig());
        undertowConfig.addSystemClassPrefix("io.jboot.app");
        undertowConfig.addHotSwapClassPrefix("io.jboot");
        return undertowConfig;
    }

    private static void tryAddMetricsSupport(WebBuilder webBuilder) {
        String url = ApplicationUtil.getConfigValue("jboot.metric.url");
        String reporter = ApplicationUtil.getConfigValue("jboot.metric.reporter");
        if (url != null && reporter != null) {
            webBuilder.addServlet("MetricsAdminServlet", "com.codahale.metrics.servlets.AdminServlet").addServletMapping("MetricsAdminServlet", url.endsWith("/*") ? url : url + "/*");
            webBuilder.addListener("io.jboot.support.metric.JbootMetricServletContextListener");
            webBuilder.addListener("io.jboot.support.metric.JbootHealthCheckServletContextListener");
        }
    }

    private static void tryAddShiroSupport(WebBuilder webBuilder) {
        String iniConfig = ApplicationUtil.getConfigValue("jboot.shiro.ini");
        if (iniConfig != null) {
            String urlMapping = ApplicationUtil.getConfigValue("jboot.shiro.urlMapping");
            if (urlMapping == null) {
                urlMapping = "/*";
            }
            webBuilder.addListener("org.apache.shiro.web.env.EnvironmentLoaderListener");
            webBuilder.addFilter("shiro", "io.jboot.support.shiro.JbootShiroFilter").addFilterUrlMapping("shiro", urlMapping, DispatcherType.REQUEST);
        }
    }

    private static void tryAddWebSocketSupport(WebBuilder webBuilder) {
        String websocketEndpoint = ApplicationUtil.getConfigValue("jboot.web.webSocketEndpoint");
        if (websocketEndpoint != null && websocketEndpoint.trim().length() > 0) {
            String[] classStrings;
            for (String c : classStrings = websocketEndpoint.split(",")) {
                webBuilder.addWebSocketEndpoint(c.trim());
            }
        }
    }
}

