/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app;

import com.jfinal.config.Interceptors;
import com.jfinal.config.Plugins;
import com.jfinal.plugin.IPlugin;
import io.jboot.app.ApplicationUtil;
import io.jboot.app.JbootApplicationConfig;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.core.JbootCoreConfig;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class JbootSimpleApplication {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Condition STOP = LOCK.newCondition();

    public static void main(String[] args) {
        JbootSimpleApplication.run(args);
    }

    public static void setBootArg(String key, Object value) {
        JbootConfigManager.me().setBootArg(key, value);
    }

    public static void run(String[] args) {
        JbootApplicationConfig appConfig = ApplicationUtil.getAppConfig(args);
        ApplicationUtil.printBannerInfo(appConfig);
        ApplicationUtil.printApplicationInfo(appConfig);
        ApplicationUtil.printClassPath();
        JbootCoreConfig coreConfig = new JbootCoreConfig();
        new RPCServer(coreConfig).start();
    }

    static class RPCServer
    extends Thread {
        private final JbootCoreConfig coreConfig;
        private final Plugins plugins = new Plugins();
        private final Interceptors interceptors = new Interceptors();

        public RPCServer(JbootCoreConfig coreConfig) {
            this.coreConfig = coreConfig;
            this.doInit();
        }

        private void doInit() {
            this.coreConfig.configInterceptor(this.interceptors);
            this.coreConfig.configPlugin(this.plugins);
            this.startPlugins();
            this.coreConfig.onStart();
        }

        private void startPlugins() {
            List pluginList = this.plugins.getPluginList();
            if (pluginList == null) {
                return;
            }
            for (IPlugin plugin : pluginList) {
                try {
                    if (plugin.start()) continue;
                    String message = "Plugin start error: " + plugin.getClass().getName();
                    throw new RuntimeException(message);
                }
                catch (Exception e) {
                    String message = "Plugin start error: " + plugin.getClass().getName() + ". \n" + e.getMessage();
                    throw new RuntimeException(message, e);
                }
            }
        }

        @Override
        public void run() {
            this.initShutdownHook();
            this.await();
        }

        private void await() {
            try {
                LOCK.lock();
                STOP.await();
            }
            catch (InterruptedException e) {
                System.err.println("jboot rpc application has stopped, interrupted by other thread!");
            }
            finally {
                LOCK.unlock();
            }
        }

        private void initShutdownHook() {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    this.coreConfig.onStop();
                }
                catch (Exception e) {
                    System.err.println("jboot rpc stop exception : " + e.toString());
                }
                System.err.println("jboot rpc application exit, all service stopped.");
                try {
                    LOCK.lock();
                    STOP.signal();
                }
                finally {
                    LOCK.unlock();
                }
            }, "jboot-rpc-application-hook"));
        }
    }
}

