/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config;

import io.jboot.app.config.ConfigPart;
import io.jboot.utils.StrUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigUtil {
    private static String rootClassPath;

    public static boolean isBlank(String string) {
        return string == null || string.trim().equals("");
    }

    public static boolean isNotBlank(String string) {
        return !ConfigUtil.isBlank(string);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<ConfigPart> parseParts(String string) {
        if (StrUtil.isBlank((String)string)) {
            return null;
        }
        LinkedList<ConfigPart> configParts = new LinkedList<ConfigPart>();
        char[] chars = string.toCharArray();
        ConfigPart part = null;
        int index = 0;
        for (char c : chars) {
            if (c == '{' && index > 0 && chars[index - 1] == '$' && part == null) {
                part = new ConfigPart();
                part.setStart(index);
            } else if (c == '}' && part != null) {
                part.setEnd(index);
                configParts.add(part);
                part = null;
            } else if (part != null) {
                part.append(c);
                if (c == ':' && part.getKeyValueIndexOf() == 0) {
                    part.setKeyValueIndexOf(index - part.getStart());
                }
            }
            ++index;
        }
        return configParts;
    }

    public static List<Method> getClassSetMethods(Class clazz) {
        Method[] methods;
        ArrayList<Method> setMethods = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().startsWith("set") || !Character.isUpperCase(method.getName().charAt(3)) || method.getName().length() <= 3 || method.getParameterCount() != 1 || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            setMethods.add(method);
        }
        return setMethods;
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String getRootClassPath() {
        if (rootClassPath == null) {
            try {
                String path = ConfigUtil.getClassLoader().getResource("").toURI().getPath();
                rootClassPath = new File(path).getAbsolutePath();
            }
            catch (Exception e) {
                try {
                    String path = ConfigUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    path = URLDecoder.decode(path, "UTF-8");
                    if (path.endsWith(File.separator)) {
                        path = path.substring(0, path.length() - 1);
                    }
                    if (path.endsWith(".jar")) {
                        path = path.substring(0, path.lastIndexOf("/") + 1);
                    }
                    rootClassPath = path;
                }
                catch (UnsupportedEncodingException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return rootClassPath;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : ConfigUtil.class.getClassLoader();
    }

    public static void doNothing(Throwable ex) {
    }

    public static final Object convert(Class<?> convertClass, String s, Type genericType) {
        if (convertClass == String.class || s == null) {
            return s;
        }
        if (convertClass == Integer.class || convertClass == Integer.TYPE) {
            return Integer.parseInt(s);
        }
        if (convertClass == Long.class || convertClass == Long.TYPE) {
            return Long.parseLong(s);
        }
        if (convertClass == Double.class || convertClass == Double.TYPE) {
            return Double.parseDouble(s);
        }
        if (convertClass == Float.class || convertClass == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (convertClass == Boolean.class || convertClass == Boolean.TYPE) {
            String value = s.toLowerCase();
            if ("1".equals(value) || "true".equals(value)) {
                return Boolean.TRUE;
            }
            if ("0".equals(value) || "false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new RuntimeException("Can not parse to boolean type of value: " + s);
        }
        if (convertClass == BigDecimal.class) {
            return new BigDecimal(s);
        }
        if (convertClass == BigInteger.class) {
            return new BigInteger(s);
        }
        if (convertClass == byte[].class) {
            return s.getBytes();
        }
        if (Map.class.isAssignableFrom(convertClass)) {
            String[] strings;
            if (!s.contains(":") || !ConfigUtil.genericClassCheck(genericType)) {
                return null;
            }
            AbstractMap map = convertClass == ConcurrentHashMap.class ? new ConcurrentHashMap() : new HashMap();
            for (String kv : strings = s.split(",")) {
                int indexOf = kv.indexOf(":");
                if (indexOf <= 0 || indexOf >= kv.trim().length() - 1) continue;
                map.put(kv.substring(0, indexOf).trim(), kv.substring(indexOf + 1).trim());
            }
            return map;
        }
        if (List.class.isAssignableFrom(convertClass)) {
            if (ConfigUtil.genericClassCheck(genericType)) {
                String[] strings;
                AbstractList list = LinkedList.class == convertClass ? new LinkedList() : new ArrayList();
                for (String s1 : strings = s.split(",")) {
                    if (s == null || s1.trim().length() <= 0) continue;
                    list.add(s1.trim());
                }
                return list;
            }
            return null;
        }
        if (Set.class.isAssignableFrom(convertClass)) {
            if (ConfigUtil.genericClassCheck(genericType)) {
                String[] strings;
                HashSet set = LinkedHashSet.class == convertClass ? new LinkedHashSet() : new HashSet();
                for (String s1 : strings = s.split(",")) {
                    if (s == null || s1.trim().length() <= 0) continue;
                    set.add(s1.trim());
                }
                return set;
            }
            return null;
        }
        if (convertClass.isArray() && convertClass.getComponentType() == String.class) {
            LinkedList<String> list = new LinkedList<String>();
            String[] strings = s.split(",");
            if (strings != null && strings.length > 0) {
                for (String s1 : strings) {
                    if (s1 == null || s1.trim().length() == 0) continue;
                    list.add(s1.trim());
                }
            }
            return list.toArray(new String[0]);
        }
        if (Class.class == convertClass) {
            try {
                return Class.forName(s, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException(convertClass.getName() + " can not be converted, please use other type in your config class!");
    }

    private static boolean genericClassCheck(Type type) {
        if (type instanceof ParameterizedType) {
            for (Type at : ((ParameterizedType)type).getActualTypeArguments()) {
                if (String.class == at) continue;
                return false;
            }
        }
        return true;
    }
}

