/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.jfinal.kit.LogKit;
import io.jboot.app.config.ConfigPart;
import io.jboot.app.config.ConfigUtil;
import io.jboot.app.config.JbootConfigChangeListener;
import io.jboot.app.config.JbootConfigDecryptor;
import io.jboot.app.config.Prop;
import io.jboot.app.config.annotation.ConfigModel;
import io.jboot.app.config.support.apollo.ApolloConfigManager;
import io.jboot.app.config.support.nacos.NacosConfigManager;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class JbootConfigManager {
    private static Map<String, String> argMap;
    private Properties mainProperties;
    private Map remoteProperties;
    private Map<String, Object> configCache = new ConcurrentHashMap<String, Object>();
    private Multimap<String, JbootConfigChangeListener> listenersMultimap = ArrayListMultimap.create();
    private JbootConfigDecryptor decryptor;
    private static JbootConfigManager instance;
    private Boolean devMode = null;

    public static JbootConfigManager me() {
        if (instance == null) {
            instance = new JbootConfigManager();
        }
        return instance;
    }

    private JbootConfigManager() {
        this.init();
    }

    private void init() {
        this.mainProperties = new Prop("jboot.properties").getProperties();
        String mode = this.getConfigValue("jboot.app.mode");
        if (ConfigUtil.isNotBlank(mode)) {
            String p = String.format("jboot-%s.properties", mode);
            this.mainProperties.putAll((Map<?, ?>)new Prop(p).getProperties());
        }
        NacosConfigManager.me().init(this);
        ApolloConfigManager.me().init(this);
    }

    public JbootConfigDecryptor getDecryptor() {
        return this.decryptor;
    }

    public void setDecryptor(JbootConfigDecryptor decryptor) {
        this.decryptor = decryptor;
    }

    public <T> T get(Class<T> clazz) {
        ConfigModel propertyConfig = clazz.getAnnotation(ConfigModel.class);
        if (propertyConfig == null) {
            return this.get(clazz, null, null);
        }
        return this.get(clazz, propertyConfig.prefix(), propertyConfig.file());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Class<T> clazz, String prefix, String file) {
        if (this.isDevMode()) {
            return this.createConfigObject(clazz, prefix, file);
        }
        Object configObject = this.configCache.get(clazz.getName() + prefix);
        if (configObject == null) {
            Class<T> clazz2 = clazz;
            synchronized (clazz2) {
                if (configObject == null) {
                    configObject = this.createConfigObject(clazz, prefix, file);
                    this.configCache.put(clazz.getName() + prefix, configObject);
                }
            }
        }
        return (T)configObject;
    }

    public <T> T refreshAndGet(Class<T> clazz) {
        ConfigModel propertyConfig = clazz.getAnnotation(ConfigModel.class);
        if (propertyConfig == null) {
            return this.refreshAndGet(clazz, null, null);
        }
        return this.refreshAndGet(clazz, propertyConfig.prefix(), propertyConfig.file());
    }

    public <T> T refreshAndGet(Class<T> clazz, String prefix, String file) {
        this.configCache.remove(clazz.getName() + prefix);
        this.refreshMainProperties();
        return this.get(clazz, prefix, file);
    }

    private void refreshMainProperties() {
        Properties properties = new Prop("jboot.properties").getProperties();
        this.mainProperties.putAll((Map<?, ?>)properties);
        String mode = this.getConfigValue(properties, "jboot.app.mode");
        if (ConfigUtil.isNotBlank(mode)) {
            String p = String.format("jboot-%s.properties", mode);
            this.mainProperties.putAll((Map<?, ?>)new Prop(p).getProperties());
        }
    }

    public <T> T createConfigObject(Class<T> clazz, String prefix, String file) {
        T configObject = ConfigUtil.newInstance(clazz);
        List<Method> setterMethods = ConfigUtil.getClassSetMethods(clazz);
        if (setterMethods != null) {
            for (Method setterMethod : setterMethods) {
                Object val;
                Prop prop;
                String filePropValue;
                String key = this.buildKey(prefix, setterMethod);
                String value = this.getConfigValue(key);
                if (ConfigUtil.isNotBlank(file) && ConfigUtil.isNotBlank(filePropValue = this.getConfigValue((prop = new Prop(file)).getProperties(), key))) {
                    value = filePropValue;
                }
                if (!ConfigUtil.isNotBlank(value) || (val = ConfigUtil.convert(setterMethod.getParameterTypes()[0], value, setterMethod.getGenericParameterTypes()[0])) == null) continue;
                try {
                    setterMethod.invoke(configObject, val);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return configObject;
    }

    private String buildKey(String prefix, Method method) {
        String key = ConfigUtil.firstCharToLowerCase(method.getName().substring(3));
        if (ConfigUtil.isNotBlank(prefix)) {
            key = prefix.trim() + "." + key;
        }
        return key;
    }

    public String getConfigValue(String key) {
        return this.getConfigValue(this.mainProperties, key);
    }

    public String getConfigValue(Properties properties, String key) {
        if (StrUtil.isBlank((String)key)) {
            return "";
        }
        String originalValue = this.getOriginalConfigValue(properties, key);
        String stringValue = this.decryptor != null ? this.decryptor.decrypt(key, originalValue) : originalValue;
        List<ConfigPart> configParts = ConfigUtil.parseParts(stringValue);
        if (configParts == null || configParts.isEmpty()) {
            return stringValue;
        }
        for (ConfigPart cp : configParts) {
            String value = this.getConfigValue(properties, cp.getKey());
            value = StrUtil.isNotBlank(value) ? value : cp.getDefaultValue();
            stringValue = stringValue.replace(cp.getPartString(), value);
        }
        return stringValue;
    }

    private String getOriginalConfigValue(Properties properties, String key) {
        String value = null;
        if (this.remoteProperties != null && ConfigUtil.isNotBlank(value = (String)this.remoteProperties.get(key))) {
            return value.trim();
        }
        value = this.getBootArg(key);
        if (ConfigUtil.isNotBlank(value)) {
            return value.trim();
        }
        value = System.getenv(key);
        if (ConfigUtil.isNotBlank(value)) {
            return value.trim();
        }
        String tempKey = key.toUpperCase().replace('.', '_');
        value = System.getenv(tempKey);
        if (ConfigUtil.isNotBlank(value)) {
            return value.trim();
        }
        value = System.getProperty(key);
        if (ConfigUtil.isNotBlank(value)) {
            return value.trim();
        }
        value = (String)properties.get(key);
        if (ConfigUtil.isNotBlank(value)) {
            return value.trim();
        }
        return null;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.mainProperties);
        if (System.getenv() != null) {
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        if (System.getProperties() != null) {
            properties.putAll((Map<?, ?>)System.getProperties());
        }
        if (this.getBootArgs() != null) {
            for (Map.Entry<String, String> entry : this.getBootArgs().entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.remoteProperties != null) {
            properties.putAll((Map<?, ?>)this.remoteProperties);
        }
        return properties;
    }

    public Map<String, Object> getConfigCache() {
        return this.configCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteProperty(String key, String value) {
        if (this.remoteProperties == null) {
            JbootConfigManager jbootConfigManager = this;
            synchronized (jbootConfigManager) {
                if (this.remoteProperties == null) {
                    this.remoteProperties = new ConcurrentHashMap();
                }
            }
        }
        this.remoteProperties.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteProperties(Map map) {
        if (this.remoteProperties == null) {
            JbootConfigManager jbootConfigManager = this;
            synchronized (jbootConfigManager) {
                if (this.remoteProperties == null) {
                    this.remoteProperties = new ConcurrentHashMap();
                }
            }
        }
        this.remoteProperties.putAll(map);
    }

    public void addConfigChangeListener(JbootConfigChangeListener listener, Class forClass) {
        ConfigModel configModel = forClass.getAnnotation(ConfigModel.class);
        if (configModel == null) {
            throw new IllegalArgumentException("forClass:" + forClass + " has no @ConfigModel annotation");
        }
        String prefix = configModel.prefix();
        List<Method> setterMethods = ConfigUtil.getClassSetMethods(forClass);
        if (setterMethods != null) {
            for (Method setterMethod : setterMethods) {
                String key = this.buildKey(prefix, setterMethod);
                this.listenersMultimap.put((Object)key, (Object)listener);
            }
        }
    }

    public void addConfigChangeListener(JbootConfigChangeListener listener, String ... forKeys) {
        if (listener == null) {
            throw new NullPointerException("listener must not null.");
        }
        if (forKeys == null || forKeys.length == 0) {
            throw new NullPointerException("forKeys must not null or empty.");
        }
        for (String forKey : forKeys) {
            this.listenersMultimap.put((Object)forKey, (Object)listener);
        }
    }

    public void removeConfigChangeListener(JbootConfigChangeListener listener) {
        this.listenersMultimap.entries().removeIf(entry -> entry.getValue() == listener);
    }

    public void notifyChangeListeners(String key, String newValue, String oldValue) {
        if (key == null) {
            return;
        }
        Collection listeners = this.listenersMultimap.get((Object)key);
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (JbootConfigChangeListener listener : listeners) {
            try {
                listener.onChange(key, newValue, oldValue);
            }
            catch (Throwable ex) {
                LogKit.error((String)ex.toString(), (Throwable)ex);
            }
        }
    }

    public void parseArgs(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        for (String arg : args) {
            int indexOf = arg.indexOf("=");
            if (!arg.startsWith("--") || indexOf <= 0) continue;
            String key = arg.substring(2, indexOf);
            String value = arg.substring(indexOf + 1);
            this.setBootArg(key, value);
        }
    }

    public void setBootArg(String key, Object value) {
        if (argMap == null) {
            argMap = new HashMap<String, String>();
        }
        argMap.put(key, value.toString());
    }

    public String getBootArg(String key) {
        if (argMap == null) {
            return null;
        }
        return argMap.get(key);
    }

    public Map<String, String> getBootArgs() {
        return argMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDevMode() {
        if (this.devMode == null) {
            JbootConfigManager jbootConfigManager = this;
            synchronized (jbootConfigManager) {
                if (this.devMode == null) {
                    String appMode = this.getConfigValue("jboot.app.mode");
                    this.devMode = null == appMode || "".equals(appMode.trim()) || "dev".equalsIgnoreCase(appMode.trim());
                }
            }
        }
        return this.devMode;
    }
}

