/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config;

import io.jboot.Jboot;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.utils.StrUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class JbootConfigUtil {
    public static <T> Map<String, T> getConfigModels(Class<T> tClass, String prefix) {
        HashMap<String, T> objMap = new HashMap<String, T>();
        boolean initDefault = false;
        HashSet<String> objNames = new HashSet<String>();
        String objPrefix = prefix + ".";
        int pointCount = StringUtils.countMatches((CharSequence)prefix, (char)'.');
        Properties prop = JbootConfigManager.me().getProperties();
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String[] keySplits;
            if (entry.getKey() == null || StrUtil.isBlank((String)entry.getKey().toString())) continue;
            String key = entry.getKey().toString().trim();
            if (key.contains("_") && Character.isUpperCase(key.charAt(0))) {
                key = key.toLowerCase().replace('_', '.');
            }
            if (!initDefault && key.startsWith(prefix) && StringUtils.countMatches((CharSequence)key, (char)'.') == pointCount + 1) {
                initDefault = true;
                T defaultObj = Jboot.config(tClass, prefix);
                objMap.put("default", defaultObj);
            }
            if (!key.startsWith(objPrefix) || entry.getValue() == null || (keySplits = key.split("\\.")).length != pointCount + 3) continue;
            objNames.add(keySplits[pointCount + 1]);
        }
        for (String name : objNames) {
            T obj = Jboot.config(tClass, objPrefix + name);
            objMap.put(name, obj);
        }
        return objMap;
    }
}

