/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config.support.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import io.jboot.Jboot;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.config.support.apollo.ApolloServerConfig;
import io.jboot.utils.StrUtil;
import java.util.Set;

public class ApolloConfigManager {
    private static final ApolloConfigManager ME = new ApolloConfigManager();

    public static ApolloConfigManager me() {
        return ME;
    }

    public void init(JbootConfigManager configManager) {
        ApolloServerConfig apolloServerConfig = configManager.get(ApolloServerConfig.class);
        if (!apolloServerConfig.isEnable() || !apolloServerConfig.isConfigOk()) {
            return;
        }
        Config config = this.getDefaultConfig();
        Set propNames = config.getPropertyNames();
        if (propNames != null && !propNames.isEmpty()) {
            for (String name : propNames) {
                String value = config.getProperty(name, null);
                configManager.setRemoteProperty(name, value);
            }
        }
        config.addChangeListener(changeEvent -> {
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                configManager.setRemoteProperty(change.getPropertyName(), change.getNewValue());
                configManager.notifyChangeListeners(change.getPropertyName(), change.getNewValue(), change.getOldValue());
            }
        });
    }

    private Config getDefaultConfig() {
        ApolloServerConfig apolloServerConfig = Jboot.config(ApolloServerConfig.class);
        if (StrUtil.isNotBlank(apolloServerConfig.getDefaultNamespace())) {
            return ConfigService.getConfig((String)apolloServerConfig.getDefaultNamespace());
        }
        return ConfigService.getAppConfig();
    }
}

