/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.config.support.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.config.support.nacos.NacosConfigIniter;
import io.jboot.app.config.support.nacos.NacosServerConfig;
import io.jboot.utils.StrUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;

public class NacosConfigManager {
    private static final NacosConfigManager ME = new NacosConfigManager();
    private Properties contentProperties;

    public static NacosConfigManager me() {
        return ME;
    }

    public void init(JbootConfigManager configManager) {
        NacosServerConfig nacosServerConfig = configManager.get(NacosServerConfig.class);
        if (!nacosServerConfig.isEnable() || !nacosServerConfig.isConfigOk()) {
            return;
        }
        try {
            ConfigService configService = NacosFactory.createConfigService((Properties)nacosServerConfig.toProperties());
            String content = configService.getConfig(nacosServerConfig.getDataId(), nacosServerConfig.getGroup(), 3000L);
            if (StrUtil.isNotBlank(content)) {
                this.contentProperties = this.str2Properties(content);
                if (this.contentProperties != null) {
                    configManager.setRemoteProperties(this.contentProperties);
                }
            }
            new NacosConfigIniter(this, configManager).initListener(configService, nacosServerConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onReceiveConfigInfo(JbootConfigManager configManager, String configInfo) {
        Properties properties = this.str2Properties(configInfo);
        if (this.contentProperties == null) {
            this.contentProperties = properties;
            configManager.setRemoteProperties(properties);
        } else {
            for (Object key : properties.keySet()) {
                String oldValue;
                String newValue = properties.getProperty(key.toString());
                if (Objects.equals(newValue, oldValue = this.contentProperties.getProperty(key.toString()))) continue;
                this.contentProperties.put(key, newValue);
                configManager.setRemoteProperty(key.toString(), newValue);
                configManager.notifyChangeListeners(key.toString(), newValue, oldValue);
            }
        }
    }

    private Properties str2Properties(String content) {
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(content));
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

