/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.undertow;

import com.jfinal.server.undertow.hotswap.HotSwapResolver;
import io.jboot.app.config.JbootConfigManager;

public class JbootHotSwapResolver
extends HotSwapResolver {
    protected String[] unHotSwapClassPrefix;

    public JbootHotSwapResolver(String[] classPathDirs) {
        super(classPathDirs);
        this.initUnHotSwapClassPrefix();
    }

    private void initUnHotSwapClassPrefix() {
        String string = JbootConfigManager.me().getConfigValue("undertow.unHotSwapClassPrefix");
        if (string != null && string.trim().length() > 0) {
            this.unHotSwapClassPrefix = string.split(",");
        }
    }

    public boolean isHotSwapClass(String className) {
        if (this.unHotSwapClassPrefix != null) {
            for (String prefix : this.unHotSwapClassPrefix) {
                if (prefix.trim().length() <= 0 || !className.startsWith(prefix.trim())) continue;
                return false;
            }
        }
        return super.isHotSwapClass(className);
    }
}

