/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.app.undertow;

import com.jfinal.server.undertow.PropExt;
import com.jfinal.server.undertow.UndertowConfig;
import com.jfinal.server.undertow.hotswap.HotSwapResolver;
import io.jboot.app.config.JbootConfigManager;
import io.jboot.app.undertow.JbootHotSwapResolver;
import java.io.IOException;
import java.net.ServerSocket;

public class JbootUndertowConfig
extends UndertowConfig {
    protected static final String UNDERTOW_PORT = "undertow.port";
    protected static final String UNDERTOW_HOST = "undertow.host";
    protected static final String UNDERTOW_RESOURCEPATH = "undertow.resourcePath";

    public JbootUndertowConfig(Class<?> jfinalConfigClass) {
        super(jfinalConfigClass);
    }

    public JbootUndertowConfig(String jfinalConfigClass) {
        super(jfinalConfigClass);
    }

    public JbootUndertowConfig(Class<?> jfinalConfigClass, String undertowConfig) {
        super(jfinalConfigClass, undertowConfig);
    }

    public JbootUndertowConfig(String jfinalConfigClass, String undertowConfig) {
        super(jfinalConfigClass, undertowConfig);
    }

    protected PropExt createPropExt(String undertowConfig) {
        String resPath;
        PropExt propExt = super.createPropExt(undertowConfig).append(new PropExt(JbootConfigManager.me().getProperties()));
        String port = propExt.get(UNDERTOW_PORT);
        Integer availablePort = JbootUndertowConfig.getAvailablePort();
        if (port == null || port.trim().length() == 0) {
            propExt.getProperties().put(UNDERTOW_PORT, "8080");
            JbootConfigManager.me().setBootArg(UNDERTOW_PORT, "8080");
        } else if ((port.trim().equals("*") || port.trim().equals("-1")) && availablePort != null) {
            propExt.getProperties().put(UNDERTOW_PORT, availablePort.toString());
            JbootConfigManager.me().setBootArg(UNDERTOW_PORT, availablePort.toString());
        }
        String host = propExt.get(UNDERTOW_HOST);
        if (host == null || host.trim().length() == 0) {
            propExt.getProperties().put(UNDERTOW_HOST, "0.0.0.0");
            JbootConfigManager.me().setBootArg(UNDERTOW_HOST, "0.0.0.0");
        }
        if ((resPath = propExt.get(UNDERTOW_RESOURCEPATH)) == null || resPath.trim().length() == 0) {
            propExt.getProperties().put(UNDERTOW_RESOURCEPATH, "classpath:webapp," + this.resourcePath);
        }
        return propExt;
    }

    public static Integer getAvailablePort() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            Integer n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException iOException) {
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public HotSwapResolver getHotSwapResolver() {
        if (this.hotSwapResolver == null) {
            this.hotSwapResolver = new JbootHotSwapResolver(this.getClassPathDirs());
            if (this.hotSwapClassPrefix != null) {
                for (String prefix : this.hotSwapClassPrefix.split(",")) {
                    if (!JbootUndertowConfig.notBlank((String)prefix)) continue;
                    this.hotSwapResolver.addHotSwapClassPrefix(prefix);
                }
            }
        }
        return this.hotSwapResolver;
    }
}

