/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache;

import io.jboot.Jboot;
import io.jboot.components.cache.JbootCache;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.components.cache.caffeine.CaffeineCacheImpl;
import io.jboot.components.cache.caredis.JbootCaredisCacheImpl;
import io.jboot.components.cache.ehcache.JbootEhcacheImpl;
import io.jboot.components.cache.ehredis.JbootEhredisCacheImpl;
import io.jboot.components.cache.j2cache.J2cacheImpl;
import io.jboot.components.cache.none.NoneCacheImpl;
import io.jboot.components.cache.redis.JbootRedisCacheImpl;
import io.jboot.core.spi.JbootSpiLoader;
import io.jboot.utils.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JbootCacheManager {
    private static JbootCacheManager me = new JbootCacheManager();
    private Map<String, JbootCache> cacheMap = new ConcurrentHashMap<String, JbootCache>();
    private JbootCacheConfig config = Jboot.config(JbootCacheConfig.class);

    private JbootCacheManager() {
    }

    public static JbootCacheManager me() {
        return me;
    }

    public JbootCache getCache() {
        return this.getCache(this.config.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JbootCache getCache(String type) {
        if (StrUtil.isBlank((String)type)) {
            throw new IllegalArgumentException("type must not be null or blank.");
        }
        JbootCache cache = this.cacheMap.get(type);
        if (cache != null) {
            return cache;
        }
        String string = type.intern();
        synchronized (string) {
            if (cache == null) {
                JbootCacheConfig cacheConfig = new JbootCacheConfig();
                cacheConfig.setType(type);
                cache = this.buildCache(cacheConfig);
                this.cacheMap.put(type, cache);
            }
        }
        return cache;
    }

    private JbootCache buildCache(JbootCacheConfig config) {
        switch (config.getType()) {
            case "ehcache": {
                return new JbootEhcacheImpl();
            }
            case "redis": {
                return new JbootRedisCacheImpl();
            }
            case "ehredis": {
                return new JbootEhredisCacheImpl();
            }
            case "j2cache": {
                return new J2cacheImpl();
            }
            case "caffeine": {
                return new CaffeineCacheImpl();
            }
            case "caredis": {
                return new JbootCaredisCacheImpl();
            }
            case "none": {
                return new NoneCacheImpl();
            }
        }
        return JbootSpiLoader.load(JbootCache.class, config.getType());
    }
}

