/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.components.cache.JbootCacheBase;
import io.jboot.components.cache.caffeine.CaffeineCacheBuilder;
import io.jboot.components.cache.caffeine.CaffeineCacheObject;
import io.jboot.components.cache.caffeine.DefaultCaffeineCacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CaffeineCacheImpl
extends JbootCacheBase {
    private Map<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();

    protected Cache getCacheOnly(String cacheName) {
        return this.cacheMap.get(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Cache getCache(String cacheName) {
        Cache cache = this.cacheMap.get(cacheName);
        if (cache != null) return cache;
        Class<CaffeineCacheImpl> clazz = CaffeineCacheImpl.class;
        synchronized (CaffeineCacheImpl.class) {
            if (cache != null) return cache;
            cache = this.createCacheBuilder().build();
            this.cacheMap.put(cacheName, cache);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cache;
        }
    }

    protected CaffeineCacheBuilder createCacheBuilder() {
        return new DefaultCaffeineCacheBuilder();
    }

    @Override
    public <T> T get(String cacheName, Object key) {
        Cache cache = this.getCache(cacheName);
        CaffeineCacheObject data = (CaffeineCacheObject)cache.getIfPresent(key);
        if (data == null) {
            return null;
        }
        if (data.isDue()) {
            cache.invalidate(key);
            return null;
        }
        return (T)data.getValue();
    }

    @Override
    public void put(String cacheName, Object key, Object value) {
        this.putData(this.getCache(cacheName), key, new CaffeineCacheObject(value));
    }

    @Override
    public void put(String cacheName, Object key, Object value, int liveSeconds) {
        this.putData(this.getCache(cacheName), key, new CaffeineCacheObject(value, liveSeconds));
    }

    @Override
    public void remove(String cacheName, Object key) {
        Cache cache = this.getCacheOnly(cacheName);
        if (cache != null) {
            cache.invalidate(key);
        }
    }

    @Override
    public void removeAll(String cacheName) {
        Cache cache = this.getCacheOnly(cacheName);
        if (cache != null) {
            cache.invalidateAll();
        }
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Cache cache = this.getCache(cacheName);
        CaffeineCacheObject data = (CaffeineCacheObject)cache.getIfPresent(key);
        if (data == null || data.isDue()) {
            Object newValue = dataLoader.load();
            if (newValue != null) {
                data = new CaffeineCacheObject(newValue);
                this.putData(cache, key, data);
            }
            return (T)newValue;
        }
        return (T)data.getValue();
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        Cache cache = this.getCache(cacheName);
        CaffeineCacheObject data = (CaffeineCacheObject)cache.getIfPresent(key);
        if (data == null || data.isDue()) {
            Object newValue = dataLoader.load();
            if (newValue != null) {
                data = new CaffeineCacheObject(newValue, liveSeconds);
                this.putData(cache, key, data);
            }
            return (T)newValue;
        }
        return (T)data.getValue();
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        Cache cache = this.getCacheOnly(cacheName);
        if (cache == null) {
            return null;
        }
        CaffeineCacheObject data = (CaffeineCacheObject)cache.getIfPresent(key);
        if (data == null) {
            return null;
        }
        return data.getTtl();
    }

    @Override
    public void setTtl(String cacheName, Object key, int seconds) {
        Cache cache = this.getCacheOnly(cacheName);
        if (cache == null) {
            return;
        }
        CaffeineCacheObject data = (CaffeineCacheObject)cache.getIfPresent(key);
        if (data == null) {
            return;
        }
        data.setLiveSeconds(seconds);
        this.putData(cache, key, data);
    }

    @Override
    public List getNames() {
        return new ArrayList<String>(this.cacheMap.keySet());
    }

    @Override
    public List getKeys(String cacheName) {
        Cache cache = this.getCacheOnly(cacheName);
        return cache == null ? null : new ArrayList(cache.asMap().keySet());
    }

    protected void putData(Cache cache, Object key, CaffeineCacheObject value) {
        value.setCachetime(System.currentTimeMillis());
        cache.put(key, (Object)value);
    }
}

