/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.caffeine;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class CaffeineCacheObject
implements Serializable {
    private Object value;
    private Integer liveSeconds;
    private Long cachetime;

    public CaffeineCacheObject() {
    }

    public CaffeineCacheObject(Object value) {
        this.value = value;
    }

    public CaffeineCacheObject(Object value, Integer liveSeconds) {
        this.value = value;
        this.liveSeconds = liveSeconds;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Integer getTtl() {
        if (this.liveSeconds == null) {
            return -1;
        }
        long timeMillis = this.cachetime - DateUtils.addSeconds((Date)new Date(), (int)(-this.liveSeconds.intValue())).getTime();
        System.out.println("timeMillis:" + timeMillis);
        if (timeMillis > 0L) {
            return (int)(timeMillis / 1000L);
        }
        return 0;
    }

    public Integer getLiveSeconds() {
        return this.liveSeconds;
    }

    public void setLiveSeconds(Integer liveSeconds) {
        this.liveSeconds = liveSeconds;
    }

    public Long getCachetime() {
        return this.cachetime;
    }

    public void setCachetime(Long cachetime) {
        this.cachetime = cachetime;
    }

    public boolean isDue() {
        if (this.liveSeconds == null) {
            return false;
        }
        return DateUtils.addSeconds((Date)new Date(), (int)(-this.liveSeconds.intValue())).getTime() > this.cachetime;
    }
}

