/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.components.cache.annotation.CacheEvict;
import io.jboot.components.cache.interceptor.Utils;
import java.lang.reflect.Method;

public class JbootCacheEvictInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        Method method = inv.getMethod();
        CacheEvict cacheEvict = method.getAnnotation(CacheEvict.class);
        if (cacheEvict == null) {
            inv.invoke();
            return;
        }
        Class<?> targetClass = inv.getTarget().getClass();
        if (cacheEvict.beforeInvocation()) {
            Utils.doCacheEvict(inv.getArgs(), targetClass, method, cacheEvict);
        }
        inv.invoke();
        if (!cacheEvict.beforeInvocation()) {
            Utils.doCacheEvict(inv.getArgs(), targetClass, method, cacheEvict);
        }
    }
}

