/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.plugin.activerecord.Page;
import io.jboot.components.cache.AopCache;
import io.jboot.components.cache.annotation.Cacheable;
import io.jboot.components.cache.interceptor.Utils;
import io.jboot.db.model.JbootModel;
import io.jboot.exception.JbootException;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.ModelUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;

public class JbootCacheInterceptor
implements Interceptor {
    private static final String NULL_VALUE = "NULL_VALUE";

    public void intercept(Invocation inv) {
        Method method = inv.getMethod();
        Cacheable cacheable = method.getAnnotation(Cacheable.class);
        if (cacheable == null) {
            inv.invoke();
            return;
        }
        String unlessString = AnnotationUtil.get(cacheable.unless());
        if (Utils.isUnless(unlessString, method, inv.getArgs())) {
            inv.invoke();
            return;
        }
        Class<?> targetClass = inv.getTarget().getClass();
        String cacheName = AnnotationUtil.get(cacheable.name());
        Utils.ensureCachenameAvailable(method, targetClass, cacheName);
        String cacheKey = Utils.buildCacheKey(AnnotationUtil.get(cacheable.key()), targetClass, method, inv.getArgs());
        Object data = AopCache.get(cacheName, cacheKey);
        if (data != null) {
            if (NULL_VALUE.equals(data)) {
                inv.setReturnValue(null);
            } else if (cacheable.returnCopyEnable()) {
                inv.setReturnValue(this.getCopyObject(inv, data));
            } else {
                inv.setReturnValue(data);
            }
        } else {
            inv.invoke();
            data = inv.getReturnValue();
            if (data != null) {
                Utils.putDataToCache(cacheable.liveSeconds(), cacheName, cacheKey, data);
                if (cacheable.returnCopyEnable()) {
                    inv.setReturnValue(this.getCopyObject(inv, data));
                }
            } else if (cacheable.nullCacheEnable()) {
                Utils.putDataToCache(cacheable.liveSeconds(), cacheName, cacheKey, NULL_VALUE);
            }
        }
    }

    private <M extends JbootModel> Object getCopyObject(Invocation inv, Object data) {
        if (data instanceof List) {
            return ModelUtil.copy((List)data);
        }
        if (data instanceof Set) {
            return ModelUtil.copy((Set)data);
        }
        if (data instanceof Page) {
            return ModelUtil.copy((Page)data);
        }
        if (data instanceof JbootModel) {
            return ModelUtil.copy((JbootModel)((Object)data));
        }
        if (data.getClass().isArray() && JbootModel.class.isAssignableFrom(data.getClass().getComponentType())) {
            return ModelUtil.copy((JbootModel[])data);
        }
        throw this.newException(null, inv, data);
    }

    private JbootException newException(Exception ex, Invocation inv, Object data) {
        String msg = "can not copy data for type [" + data.getClass().getName() + "] in method :" + ClassUtil.buildMethodString(inv.getMethod()) + " , can not use @Cacheable(returnCopyEnable=true) annotation";
        return ex == null ? new JbootException(msg) : new JbootException(msg, ex);
    }
}

