/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import io.jboot.components.cache.annotation.CachePut;
import io.jboot.components.cache.interceptor.Utils;
import io.jboot.utils.AnnotationUtil;
import java.lang.reflect.Method;

public class JbootCachePutInterceptor
implements Interceptor {
    public void intercept(Invocation inv) {
        inv.invoke();
        Method method = inv.getMethod();
        CachePut cachePut = method.getAnnotation(CachePut.class);
        if (cachePut == null) {
            return;
        }
        Object data = inv.getReturnValue();
        String unless = AnnotationUtil.get(cachePut.unless());
        if (Utils.isUnless(unless, method, inv.getArgs())) {
            return;
        }
        Class<?> targetClass = inv.getTarget().getClass();
        String cacheName = AnnotationUtil.get(cachePut.name());
        Utils.ensureCachenameAvailable(method, targetClass, cacheName);
        String cacheKey = Utils.buildCacheKey(AnnotationUtil.get(cachePut.key()), targetClass, method, inv.getArgs());
        Utils.putDataToCache(cachePut.liveSeconds(), cacheName, cacheKey, data);
    }
}

