/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.interceptor;

import com.jfinal.log.Log;
import com.jfinal.template.Engine;
import io.jboot.Jboot;
import io.jboot.components.cache.AopCache;
import io.jboot.components.cache.JbootCacheConfig;
import io.jboot.components.cache.annotation.CacheEvict;
import io.jboot.exception.JbootException;
import io.jboot.utils.AnnotationUtil;
import io.jboot.utils.ArrayUtil;
import io.jboot.utils.ClassUtil;
import io.jboot.utils.StrUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;

class Utils {
    static final Log LOG = Log.getLog(Utils.class);
    static final Engine ENGINE = new Engine("JbootCacheRender");
    private static final JbootCacheConfig CONFIG = Jboot.config(JbootCacheConfig.class);

    Utils() {
    }

    static String engineRender(String template, Method method, Object[] arguments) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        int x = 0;
        for (Parameter p : method.getParameters()) {
            if (!p.isNamePresent()) {
                throw new RuntimeException(" Maven or IDE config is error. see http://www.jfinal.com/doc/3-3 ");
            }
            datas.put(p.getName(), arguments[x++]);
        }
        return ENGINE.getTemplateByString(template).renderToString(datas);
    }

    static String buildCacheKey(String key, Class clazz, Method method, Object[] arguments) {
        clazz = ClassUtil.getUsefulClass(clazz);
        if (StrUtil.isNotBlank(key)) {
            return Utils.renderKey(key, method, arguments);
        }
        StringBuilder keyBuilder = new StringBuilder(clazz.getName());
        keyBuilder.append("#").append(method.getName());
        if (ArrayUtil.isNullOrEmpty(arguments)) {
            return keyBuilder.toString();
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        int index = 0;
        for (Object argument : arguments) {
            String argStr = Utils.converteToString(argument);
            Utils.ensureArgumentNotNull(argStr, clazz, method);
            keyBuilder.append(paramTypes[index++].getClass().getName()).append(":").append(argStr).append("-");
        }
        return keyBuilder.deleteCharAt(keyBuilder.length() - 1).toString();
    }

    private static String renderKey(String key, Method method, Object[] arguments) {
        if (!key.contains("#(") || !key.contains(")")) {
            return key;
        }
        return Utils.engineRender(key, method, arguments);
    }

    public static void ensureArgumentNotNull(String argument, Class clazz, Method method) {
        if (argument == null) {
            throw new JbootException("not support empty key for annotation @Cacheable, @CacheEvict or @CachePut at method[" + ClassUtil.buildMethodString(method) + "], please config key properties in @Cacheable, @CacheEvict or @CachePut annotation.");
        }
    }

    public static void ensureCachenameAvailable(Method method, Class targetClass, String cacheName) {
        if (StrUtil.isBlank((String)cacheName)) {
            throw new JbootException(String.format("CacheEvict.name() must not empty in method [%s].", ClassUtil.buildMethodString(method)));
        }
    }

    static boolean isPrimitive(Class clazz) {
        return clazz == String.class || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Double.class || clazz == Double.TYPE || clazz == Float.class || clazz == Float.TYPE || clazz == Boolean.class || clazz == Boolean.TYPE || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Timestamp.class || clazz == Time.class;
    }

    static String converteToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (!Utils.isPrimitive(object.getClass())) {
            return null;
        }
        if (object instanceof java.util.Date) {
            return String.valueOf(((java.util.Date)object).getTime());
        }
        return String.valueOf(object);
    }

    static boolean isUnless(String unlessString, Method method, Object[] arguments) {
        if (StrUtil.isBlank((String)unlessString)) {
            return false;
        }
        String template = "#(" + unlessString + ")";
        return "true".equals(Utils.engineRender(template, method, arguments));
    }

    static void doCacheEvict(Object[] arguments, Class targetClass, Method method, CacheEvict evict) {
        String unless = AnnotationUtil.get(evict.unless());
        if (Utils.isUnless(unless, method, arguments)) {
            return;
        }
        String cacheName = AnnotationUtil.get(evict.name());
        if (StrUtil.isBlank((String)cacheName)) {
            throw new JbootException(String.format("CacheEvict.name()  must not empty in method [%s].", ClassUtil.buildMethodString(method)));
        }
        String cacheKey = AnnotationUtil.get(evict.key());
        if (StrUtil.isBlank((String)cacheKey) || "*".equals(cacheKey)) {
            AopCache.removeAll(cacheName);
        } else {
            cacheKey = Utils.buildCacheKey(cacheKey, targetClass, method, arguments);
            AopCache.remove(cacheName, cacheKey);
        }
    }

    static void putDataToCache(int liveSeconds, String cacheName, String cacheKey, Object data) {
        int n = liveSeconds = liveSeconds > 0 ? liveSeconds : CONFIG.getAopCacheLiveSeconds();
        if (liveSeconds > 0) {
            AopCache.put(cacheName, cacheKey, data, liveSeconds);
        } else {
            AopCache.put(cacheName, cacheKey, data);
        }
    }
}

