/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.cache.redis;

import com.jfinal.plugin.ehcache.IDataLoader;
import io.jboot.Jboot;
import io.jboot.components.cache.JbootCacheBase;
import io.jboot.components.cache.redis.JbootRedisCacheConfig;
import io.jboot.exception.JbootIllegalConfigException;
import io.jboot.support.redis.JbootRedis;
import io.jboot.support.redis.JbootRedisManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JbootRedisCacheImpl
extends JbootCacheBase {
    private JbootRedis redis;
    private static final String redisCacheNamesKey = "jboot_cache_names";

    public JbootRedisCacheImpl() {
        JbootRedisCacheConfig redisConfig = Jboot.config(JbootRedisCacheConfig.class);
        this.redis = redisConfig.isConfigOk() ? JbootRedisManager.me().getRedis(redisConfig) : Jboot.getRedis();
        if (this.redis == null) {
            throw new JbootIllegalConfigException("can not get redis, please check your jboot.properties , please correct config jboot.cache.redis.host or jboot.redis.host ");
        }
    }

    @Override
    public <T> T get(String cacheName, Object key) {
        return this.redis.get(this.buildKey(cacheName, key));
    }

    @Override
    public void put(String cacheName, Object key, Object value) {
        if (value == null) {
            return;
        }
        this.redis.set(this.buildKey(cacheName, key), value);
        this.redis.sadd(redisCacheNamesKey, cacheName);
    }

    @Override
    public void put(String cacheName, Object key, Object value, int liveSeconds) {
        if (value == null) {
            return;
        }
        if (liveSeconds <= 0) {
            this.put(cacheName, key, value);
            return;
        }
        this.redis.setex(this.buildKey(cacheName, key), liveSeconds, value);
        this.redis.sadd(redisCacheNamesKey, cacheName);
    }

    @Override
    public void remove(String cacheName, Object key) {
        this.redis.del((Object)this.buildKey(cacheName, key));
    }

    @Override
    public void removeAll(String cacheName) {
        Object[] keys = new String[]{};
        keys = this.redis.keys(cacheName + ":*").toArray(keys);
        if (keys != null && keys.length > 0) {
            this.redis.del(keys);
        }
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data);
        }
        return data;
    }

    private String buildKey(String cacheName, Object key) {
        if (key instanceof Number) {
            return String.format("%s:I:%s", cacheName, key);
        }
        Class<?> keyClass = key.getClass();
        if (String.class.equals(keyClass) || StringBuffer.class.equals(keyClass) || StringBuilder.class.equals(keyClass)) {
            return String.format("%s:S:%s", cacheName, key);
        }
        return String.format("%s:O:%s", cacheName, key);
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, int liveSeconds) {
        if (liveSeconds <= 0) {
            return this.get(cacheName, key, dataLoader);
        }
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data, liveSeconds);
        }
        return data;
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        Long ttl = this.redis.ttl(this.buildKey(cacheName, key));
        return ttl != null ? Integer.valueOf(ttl.intValue()) : null;
    }

    @Override
    public void setTtl(String cacheName, Object key, int seconds) {
        this.redis.expire(this.buildKey(cacheName, key), seconds);
    }

    @Override
    public List getNames() {
        Set set = this.redis.smembers(redisCacheNamesKey);
        return set == null ? null : new ArrayList(set);
    }

    @Override
    public List getKeys(String cacheName) {
        Set<String> keyset = this.redis.keys(cacheName + ":*");
        if (keyset == null || keyset.size() == 0) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>(keyset);
        for (int i = 0; i < keys.size(); ++i) {
            keys.set(i, ((String)keys.get(i)).substring(cacheName.length() + 3));
        }
        return keys;
    }

    public JbootRedis getRedis() {
        return this.redis;
    }
}

