/*
 * Decompiled with CFR 0.152.
 */
package io.jboot.components.gateway;

import com.jfinal.log.Log;
import io.jboot.components.gateway.JbootGatewayConfig;
import io.jboot.exception.JbootException;
import io.jboot.utils.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GatewayHttpProxy {
    private static final Log LOG = Log.getLog(GatewayHttpProxy.class);
    private int readTimeOut;
    private int connectTimeOut;
    private int retries;
    private String contentType;
    private Exception exception;
    private static X509TrustManager trustAnyTrustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    private static HostnameVerifier hnv = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public GatewayHttpProxy(JbootGatewayConfig config) {
        this.readTimeOut = config.getProxyReadTimeout();
        this.connectTimeOut = config.getProxyConnectTimeout();
        this.retries = config.getProxyRetries();
        this.contentType = config.getProxyContentType();
    }

    public void sendRequest(String url, HttpServletRequest req, HttpServletResponse resp) {
        int triesCount = this.retries < 0 ? 0 : this.retries;
        Exception exception = null;
        do {
            try {
                exception = null;
                this.doSendRequest(url, req, resp);
            }
            catch (Exception ex) {
                exception = ex;
            }
        } while (exception != null && triesCount-- > 0);
        if (exception != null) {
            this.exception = exception;
            LOG.error(exception.toString(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendRequest(String url, HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HttpURLConnection conn = null;
        try {
            conn = GatewayHttpProxy.getConnection(url);
            this.configConnection(conn, req);
            if ("get".equalsIgnoreCase(req.getMethod())) {
                conn.connect();
            } else {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                this.copyRequestStreamToConnection(req, conn);
            }
            this.configResponse(resp, conn);
            this.copyConnStreamToResponse(conn, resp);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRequestStreamToConnection(HttpServletRequest req, HttpURLConnection conn) throws IOException {
        OutputStream outStream = null;
        ServletInputStream inStream = null;
        try {
            int len;
            outStream = conn.getOutputStream();
            inStream = req.getInputStream();
            byte[] buffer = new byte[1024];
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
        }
        catch (Throwable throwable) {
            GatewayHttpProxy.quetlyClose(new Closeable[]{outStream, inStream});
            throw throwable;
        }
        GatewayHttpProxy.quetlyClose(new Closeable[]{outStream, inStream});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyConnStreamToResponse(HttpURLConnection conn, HttpServletResponse resp) throws IOException {
        InputStream inStream = null;
        InputStreamReader reader = null;
        try {
            if (!resp.isCommitted()) {
                int len;
                PrintWriter writer = resp.getWriter();
                inStream = GatewayHttpProxy.getInputStream(conn);
                reader = new InputStreamReader(inStream);
                char[] buffer = new char[1024];
                while ((len = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, len);
                }
            }
        }
        catch (Throwable throwable) {
            GatewayHttpProxy.quetlyClose(inStream, reader);
            throw throwable;
        }
        GatewayHttpProxy.quetlyClose(inStream, reader);
    }

    private static void quetlyClose(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void configResponse(HttpServletResponse resp, HttpURLConnection conn) throws IOException {
        resp.setContentType(this.contentType);
        resp.setStatus(conn.getResponseCode());
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        if (headerFields != null && !headerFields.isEmpty()) {
            Set<String> headerNames = headerFields.keySet();
            for (String headerName : headerNames) {
                String headerFieldValue;
                if (StrUtil.isBlank((String)headerName) || "Content-Encoding".equalsIgnoreCase(headerName) || "Content-Type".equalsIgnoreCase(headerName) || !StrUtil.isNotBlank(headerFieldValue = conn.getHeaderField(headerName))) continue;
                resp.setHeader(headerName, headerFieldValue);
            }
        }
    }

    private static InputStream getInputStream(HttpURLConnection conn) throws IOException {
        InputStream stream;
        InputStream inputStream = stream = conn.getResponseCode() >= 400 ? conn.getErrorStream() : conn.getInputStream();
        if ("gzip".equalsIgnoreCase(conn.getContentEncoding())) {
            return new GZIPInputStream(stream);
        }
        return stream;
    }

    private void configConnection(HttpURLConnection conn, HttpServletRequest req) throws ProtocolException {
        conn.setReadTimeout(this.readTimeOut);
        conn.setConnectTimeout(this.connectTimeOut);
        conn.setInstanceFollowRedirects(false);
        conn.setUseCaches(false);
        conn.setRequestMethod(req.getMethod());
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerFieldValue;
            String headerName = (String)headerNames.nextElement();
            if (!StrUtil.isNotBlank(headerName) || !StrUtil.isNotBlank(headerFieldValue = req.getHeader(headerName))) continue;
            conn.setRequestProperty(headerName, headerFieldValue);
        }
    }

    private static HttpURLConnection getConnection(String urlString) {
        try {
            if (urlString.toLowerCase().startsWith("https")) {
                return GatewayHttpProxy.getHttpsConnection(urlString);
            }
            return GatewayHttpProxy.getHttpConnection(urlString);
        }
        catch (Throwable ex) {
            throw new JbootException(ex);
        }
    }

    private static HttpURLConnection getHttpConnection(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn;
    }

    private static HttpsURLConnection getHttpsConnection(String urlString) throws Exception {
        URL url = new URL(urlString);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setHostnameVerifier(hnv);
        SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
        if (sslContext != null) {
            TrustManager[] tm = new TrustManager[]{trustAnyTrustManager};
            sslContext.init(null, tm, null);
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            conn.setSSLSocketFactory(ssf);
        }
        return conn;
    }

    public Exception getException() {
        return this.exception;
    }
}

